// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents a gateway route returned by a list operation.
 */
class GatewayRouteRef private constructor(builder: Builder) {
    /**
     * The full Amazon Resource Name (ARN) for the gateway route.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the gateway route.
     */
    val gatewayRouteName: kotlin.String? = builder.gatewayRouteName
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the service mesh that the resource resides in.
     */
    val meshName: kotlin.String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
     * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val resourceOwner: kotlin.String? = builder.resourceOwner
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    val version: kotlin.Long? = builder.version
    /**
     * The virtual gateway that the gateway route is associated with.
     */
    val virtualGatewayName: kotlin.String? = builder.virtualGatewayName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.GatewayRouteRef = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayRouteRef(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("gatewayRouteName=$gatewayRouteName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("version=$version,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (gatewayRouteName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayRouteRef

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (gatewayRouteName != other.gatewayRouteName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (version != other.version) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.GatewayRouteRef = Builder(this).apply(block).build()

    class Builder {
        /**
         * The full Amazon Resource Name (ARN) for the gateway route.
         */
        var arn: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the gateway route.
         */
        var gatewayRouteName: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service mesh that the resource resides in.
         */
        var meshName: kotlin.String? = null
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: kotlin.String? = null
        /**
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
         * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var resourceOwner: kotlin.String? = null
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        var version: kotlin.Long? = null
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        var virtualGatewayName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.GatewayRouteRef) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.gatewayRouteName = x.gatewayRouteName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.version = x.version
            this.virtualGatewayName = x.virtualGatewayName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.GatewayRouteRef = GatewayRouteRef(this)
    }
}
