// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.appmesh.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.appmesh.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * App Mesh is a service mesh based on the Envoy proxy that makes it easy to monitor and
 * control microservices. App Mesh standardizes how your microservices communicate, giving you
 * end-to-end visibility and helping to ensure high availability for your applications.
 * App Mesh gives you consistent visibility and network traffic controls for every
 * microservice in an application. You can use App Mesh with Amazon Web Services Fargate, Amazon ECS, Amazon EKS,
 * Kubernetes on Amazon Web Services, and Amazon EC2.
 * App Mesh supports microservice applications that use service discovery naming for their
 * components. For more information about service discovery on Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery in the Amazon Elastic Container Service Developer Guide. Kubernetes
 * kube-dns and coredns are supported. For more information,
 * see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">DNS
 * for Services and Pods in the Kubernetes documentation.
 */
interface AppMeshClient : SdkClient {

    override val serviceName: String
        get() = "App Mesh"
    /**
     * AppMeshClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): AppMeshClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultAppMeshClient(config)
        }

        operator fun invoke(config: Config): AppMeshClient = DefaultAppMeshClient(config)

        /**
         * Construct a [AppMeshClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): AppMeshClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return AppMeshClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a gateway route.
     * A gateway route is attached to a virtual gateway and routes traffic to an existing
     * virtual service. If a route matches a request, it can distribute traffic to a target
     * virtual service.
     * For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes.
     */
    suspend fun createGatewayRoute(input: CreateGatewayRouteRequest): CreateGatewayRouteResponse

    /**
     * Creates a gateway route.
     * A gateway route is attached to a virtual gateway and routes traffic to an existing
     * virtual service. If a route matches a request, it can distribute traffic to a target
     * virtual service.
     * For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes.
     */
    suspend fun createGatewayRoute(block: CreateGatewayRouteRequest.Builder.() -> Unit) = createGatewayRoute(CreateGatewayRouteRequest.Builder().apply(block).build())

    /**
     * Creates a service mesh.
     * A service mesh is a logical boundary for network traffic between services that are
     * represented by resources within the mesh. After you create your service mesh, you can
     * create virtual services, virtual nodes, virtual routers, and routes to distribute traffic
     * between the applications in your mesh.
     * For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes.
     */
    suspend fun createMesh(input: CreateMeshRequest): CreateMeshResponse

    /**
     * Creates a service mesh.
     * A service mesh is a logical boundary for network traffic between services that are
     * represented by resources within the mesh. After you create your service mesh, you can
     * create virtual services, virtual nodes, virtual routers, and routes to distribute traffic
     * between the applications in your mesh.
     * For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes.
     */
    suspend fun createMesh(block: CreateMeshRequest.Builder.() -> Unit) = createMesh(CreateMeshRequest.Builder().apply(block).build())

    /**
     * Creates a route that is associated with a virtual router.
     * You can route several different protocols and define a retry policy for a route.
     * Traffic can be routed to one or more virtual nodes.
     * For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes.
     */
    suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates a route that is associated with a virtual router.
     * You can route several different protocols and define a retry policy for a route.
     * Traffic can be routed to one or more virtual nodes.
     * For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes.
     */
    suspend fun createRoute(block: CreateRouteRequest.Builder.() -> Unit) = createRoute(CreateRouteRequest.Builder().apply(block).build())

    /**
     * Creates a virtual gateway.
     * A virtual gateway allows resources outside your mesh to communicate to resources that
     * are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS
     * task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which
     * represents an Envoy running with an application, a virtual gateway represents Envoy
     * deployed by itself.
     * For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways.
     */
    suspend fun createVirtualGateway(input: CreateVirtualGatewayRequest): CreateVirtualGatewayResponse

    /**
     * Creates a virtual gateway.
     * A virtual gateway allows resources outside your mesh to communicate to resources that
     * are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS
     * task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which
     * represents an Envoy running with an application, a virtual gateway represents Envoy
     * deployed by itself.
     * For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways.
     */
    suspend fun createVirtualGateway(block: CreateVirtualGatewayRequest.Builder.() -> Unit) = createVirtualGateway(CreateVirtualGatewayRequest.Builder().apply(block).build())

    /**
     * Creates a virtual node within a service mesh.
     * A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS
     * service or a Kubernetes deployment. When you create a virtual node, you can specify the
     * service discovery information for your task group, and whether the proxy running in a task
     * group will communicate with other proxies using Transport Layer Security (TLS).
     * You define a listener for any inbound traffic that your virtual node
     * expects. Any virtual service that your virtual node expects to communicate to is specified
     * as a backend.
     * The response metadata for your new virtual node contains the arn that is
     * associated with the virtual node. Set this value to the full ARN; for example,
     * arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp)
     * as the APPMESH_RESOURCE_ARN environment variable for your task group's Envoy
     * proxy container in your task definition or pod spec. This is then mapped to the
     * node.id and node.cluster Envoy parameters.
     * By default, App Mesh uses the name of the resource you specified in
     * APPMESH_RESOURCE_ARN when Envoy is referring to itself in metrics and
     * traces. You can override this behavior by setting the
     * APPMESH_RESOURCE_CLUSTER environment variable with your own name.
     * For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes. You must be using 1.15.0 or later of the Envoy image when
     * setting these variables. For more information aboutApp Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy image in
     * the AWS App Mesh User Guide.
     */
    suspend fun createVirtualNode(input: CreateVirtualNodeRequest): CreateVirtualNodeResponse

    /**
     * Creates a virtual node within a service mesh.
     * A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS
     * service or a Kubernetes deployment. When you create a virtual node, you can specify the
     * service discovery information for your task group, and whether the proxy running in a task
     * group will communicate with other proxies using Transport Layer Security (TLS).
     * You define a listener for any inbound traffic that your virtual node
     * expects. Any virtual service that your virtual node expects to communicate to is specified
     * as a backend.
     * The response metadata for your new virtual node contains the arn that is
     * associated with the virtual node. Set this value to the full ARN; for example,
     * arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp)
     * as the APPMESH_RESOURCE_ARN environment variable for your task group's Envoy
     * proxy container in your task definition or pod spec. This is then mapped to the
     * node.id and node.cluster Envoy parameters.
     * By default, App Mesh uses the name of the resource you specified in
     * APPMESH_RESOURCE_ARN when Envoy is referring to itself in metrics and
     * traces. You can override this behavior by setting the
     * APPMESH_RESOURCE_CLUSTER environment variable with your own name.
     * For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes. You must be using 1.15.0 or later of the Envoy image when
     * setting these variables. For more information aboutApp Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy image in
     * the AWS App Mesh User Guide.
     */
    suspend fun createVirtualNode(block: CreateVirtualNodeRequest.Builder.() -> Unit) = createVirtualNode(CreateVirtualNodeRequest.Builder().apply(block).build())

    /**
     * Creates a virtual router within a service mesh.
     * Specify a listener for any inbound traffic that your virtual router
     * receives. Create a virtual router for each protocol and port that you need to route.
     * Virtual routers handle traffic for one or more virtual services within your mesh. After you
     * create your virtual router, create and associate routes for your virtual router that direct
     * incoming requests to different virtual nodes.
     * For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers.
     */
    suspend fun createVirtualRouter(input: CreateVirtualRouterRequest): CreateVirtualRouterResponse

    /**
     * Creates a virtual router within a service mesh.
     * Specify a listener for any inbound traffic that your virtual router
     * receives. Create a virtual router for each protocol and port that you need to route.
     * Virtual routers handle traffic for one or more virtual services within your mesh. After you
     * create your virtual router, create and associate routes for your virtual router that direct
     * incoming requests to different virtual nodes.
     * For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers.
     */
    suspend fun createVirtualRouter(block: CreateVirtualRouterRequest.Builder.() -> Unit) = createVirtualRouter(CreateVirtualRouterRequest.Builder().apply(block).build())

    /**
     * Creates a virtual service within a service mesh.
     * A virtual service is an abstraction of a real service that is provided by a virtual node
     * directly or indirectly by means of a virtual router. Dependent services call your virtual
     * service by its virtualServiceName, and those requests are routed to the
     * virtual node or virtual router that is specified as the provider for the virtual
     * service.
     * For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services.
     */
    suspend fun createVirtualService(input: CreateVirtualServiceRequest): CreateVirtualServiceResponse

    /**
     * Creates a virtual service within a service mesh.
     * A virtual service is an abstraction of a real service that is provided by a virtual node
     * directly or indirectly by means of a virtual router. Dependent services call your virtual
     * service by its virtualServiceName, and those requests are routed to the
     * virtual node or virtual router that is specified as the provider for the virtual
     * service.
     * For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services.
     */
    suspend fun createVirtualService(block: CreateVirtualServiceRequest.Builder.() -> Unit) = createVirtualService(CreateVirtualServiceRequest.Builder().apply(block).build())

    /**
     * Deletes an existing gateway route.
     */
    suspend fun deleteGatewayRoute(input: DeleteGatewayRouteRequest): DeleteGatewayRouteResponse

    /**
     * Deletes an existing gateway route.
     */
    suspend fun deleteGatewayRoute(block: DeleteGatewayRouteRequest.Builder.() -> Unit) = deleteGatewayRoute(DeleteGatewayRouteRequest.Builder().apply(block).build())

    /**
     * Deletes an existing service mesh.
     * You must delete all resources (virtual services, routes, virtual routers, and virtual
     * nodes) in the service mesh before you can delete the mesh itself.
     */
    suspend fun deleteMesh(input: DeleteMeshRequest): DeleteMeshResponse

    /**
     * Deletes an existing service mesh.
     * You must delete all resources (virtual services, routes, virtual routers, and virtual
     * nodes) in the service mesh before you can delete the mesh itself.
     */
    suspend fun deleteMesh(block: DeleteMeshRequest.Builder.() -> Unit) = deleteMesh(DeleteMeshRequest.Builder().apply(block).build())

    /**
     * Deletes an existing route.
     */
    suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes an existing route.
     */
    suspend fun deleteRoute(block: DeleteRouteRequest.Builder.() -> Unit) = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

    /**
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway
     * routes are associated to it.
     */
    suspend fun deleteVirtualGateway(input: DeleteVirtualGatewayRequest): DeleteVirtualGatewayResponse

    /**
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway
     * routes are associated to it.
     */
    suspend fun deleteVirtualGateway(block: DeleteVirtualGatewayRequest.Builder.() -> Unit) = deleteVirtualGateway(DeleteVirtualGatewayRequest.Builder().apply(block).build())

    /**
     * Deletes an existing virtual node.
     * You must delete any virtual services that list a virtual node as a service provider
     * before you can delete the virtual node itself.
     */
    suspend fun deleteVirtualNode(input: DeleteVirtualNodeRequest): DeleteVirtualNodeResponse

    /**
     * Deletes an existing virtual node.
     * You must delete any virtual services that list a virtual node as a service provider
     * before you can delete the virtual node itself.
     */
    suspend fun deleteVirtualNode(block: DeleteVirtualNodeRequest.Builder.() -> Unit) = deleteVirtualNode(DeleteVirtualNodeRequest.Builder().apply(block).build())

    /**
     * Deletes an existing virtual router.
     * You must delete any routes associated with the virtual router before you can delete the
     * router itself.
     */
    suspend fun deleteVirtualRouter(input: DeleteVirtualRouterRequest): DeleteVirtualRouterResponse

    /**
     * Deletes an existing virtual router.
     * You must delete any routes associated with the virtual router before you can delete the
     * router itself.
     */
    suspend fun deleteVirtualRouter(block: DeleteVirtualRouterRequest.Builder.() -> Unit) = deleteVirtualRouter(DeleteVirtualRouterRequest.Builder().apply(block).build())

    /**
     * Deletes an existing virtual service.
     */
    suspend fun deleteVirtualService(input: DeleteVirtualServiceRequest): DeleteVirtualServiceResponse

    /**
     * Deletes an existing virtual service.
     */
    suspend fun deleteVirtualService(block: DeleteVirtualServiceRequest.Builder.() -> Unit) = deleteVirtualService(DeleteVirtualServiceRequest.Builder().apply(block).build())

    /**
     * Describes an existing gateway route.
     */
    suspend fun describeGatewayRoute(input: DescribeGatewayRouteRequest): DescribeGatewayRouteResponse

    /**
     * Describes an existing gateway route.
     */
    suspend fun describeGatewayRoute(block: DescribeGatewayRouteRequest.Builder.() -> Unit) = describeGatewayRoute(DescribeGatewayRouteRequest.Builder().apply(block).build())

    /**
     * Describes an existing service mesh.
     */
    suspend fun describeMesh(input: DescribeMeshRequest): DescribeMeshResponse

    /**
     * Describes an existing service mesh.
     */
    suspend fun describeMesh(block: DescribeMeshRequest.Builder.() -> Unit) = describeMesh(DescribeMeshRequest.Builder().apply(block).build())

    /**
     * Describes an existing route.
     */
    suspend fun describeRoute(input: DescribeRouteRequest): DescribeRouteResponse

    /**
     * Describes an existing route.
     */
    suspend fun describeRoute(block: DescribeRouteRequest.Builder.() -> Unit) = describeRoute(DescribeRouteRequest.Builder().apply(block).build())

    /**
     * Describes an existing virtual gateway.
     */
    suspend fun describeVirtualGateway(input: DescribeVirtualGatewayRequest): DescribeVirtualGatewayResponse

    /**
     * Describes an existing virtual gateway.
     */
    suspend fun describeVirtualGateway(block: DescribeVirtualGatewayRequest.Builder.() -> Unit) = describeVirtualGateway(DescribeVirtualGatewayRequest.Builder().apply(block).build())

    /**
     * Describes an existing virtual node.
     */
    suspend fun describeVirtualNode(input: DescribeVirtualNodeRequest): DescribeVirtualNodeResponse

    /**
     * Describes an existing virtual node.
     */
    suspend fun describeVirtualNode(block: DescribeVirtualNodeRequest.Builder.() -> Unit) = describeVirtualNode(DescribeVirtualNodeRequest.Builder().apply(block).build())

    /**
     * Describes an existing virtual router.
     */
    suspend fun describeVirtualRouter(input: DescribeVirtualRouterRequest): DescribeVirtualRouterResponse

    /**
     * Describes an existing virtual router.
     */
    suspend fun describeVirtualRouter(block: DescribeVirtualRouterRequest.Builder.() -> Unit) = describeVirtualRouter(DescribeVirtualRouterRequest.Builder().apply(block).build())

    /**
     * Describes an existing virtual service.
     */
    suspend fun describeVirtualService(input: DescribeVirtualServiceRequest): DescribeVirtualServiceResponse

    /**
     * Describes an existing virtual service.
     */
    suspend fun describeVirtualService(block: DescribeVirtualServiceRequest.Builder.() -> Unit) = describeVirtualService(DescribeVirtualServiceRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing gateway routes that are associated to a virtual
     * gateway.
     */
    suspend fun listGatewayRoutes(input: ListGatewayRoutesRequest): ListGatewayRoutesResponse

    /**
     * Returns a list of existing gateway routes that are associated to a virtual
     * gateway.
     */
    suspend fun listGatewayRoutes(block: ListGatewayRoutesRequest.Builder.() -> Unit) = listGatewayRoutes(ListGatewayRoutesRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing service meshes.
     */
    suspend fun listMeshes(input: ListMeshesRequest): ListMeshesResponse

    /**
     * Returns a list of existing service meshes.
     */
    suspend fun listMeshes(block: ListMeshesRequest.Builder.() -> Unit) = listMeshes(ListMeshesRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing routes in a service mesh.
     */
    suspend fun listRoutes(input: ListRoutesRequest): ListRoutesResponse

    /**
     * Returns a list of existing routes in a service mesh.
     */
    suspend fun listRoutes(block: ListRoutesRequest.Builder.() -> Unit) = listRoutes(ListRoutesRequest.Builder().apply(block).build())

    /**
     * List the tags for an App Mesh resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List the tags for an App Mesh resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing virtual gateways in a service mesh.
     */
    suspend fun listVirtualGateways(input: ListVirtualGatewaysRequest): ListVirtualGatewaysResponse

    /**
     * Returns a list of existing virtual gateways in a service mesh.
     */
    suspend fun listVirtualGateways(block: ListVirtualGatewaysRequest.Builder.() -> Unit) = listVirtualGateways(ListVirtualGatewaysRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing virtual nodes.
     */
    suspend fun listVirtualNodes(input: ListVirtualNodesRequest): ListVirtualNodesResponse

    /**
     * Returns a list of existing virtual nodes.
     */
    suspend fun listVirtualNodes(block: ListVirtualNodesRequest.Builder.() -> Unit) = listVirtualNodes(ListVirtualNodesRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing virtual routers in a service mesh.
     */
    suspend fun listVirtualRouters(input: ListVirtualRoutersRequest): ListVirtualRoutersResponse

    /**
     * Returns a list of existing virtual routers in a service mesh.
     */
    suspend fun listVirtualRouters(block: ListVirtualRoutersRequest.Builder.() -> Unit) = listVirtualRouters(ListVirtualRoutersRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing virtual services in a service mesh.
     */
    suspend fun listVirtualServices(input: ListVirtualServicesRequest): ListVirtualServicesResponse

    /**
     * Returns a list of existing virtual services in a service mesh.
     */
    suspend fun listVirtualServices(block: ListVirtualServicesRequest.Builder.() -> Unit) = listVirtualServices(ListVirtualServicesRequest.Builder().apply(block).build())

    /**
     * Associates the specified tags to a resource with the specified resourceArn.
     * If existing tags on a resource aren't specified in the request parameters, they aren't
     * changed. When a resource is deleted, the tags associated with that resource are also
     * deleted.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates the specified tags to a resource with the specified resourceArn.
     * If existing tags on a resource aren't specified in the request parameters, they aren't
     * changed. When a resource is deleted, the tags associated with that resource are also
     * deleted.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an existing gateway route that is associated to a specified virtual gateway in a
     * service mesh.
     */
    suspend fun updateGatewayRoute(input: UpdateGatewayRouteRequest): UpdateGatewayRouteResponse

    /**
     * Updates an existing gateway route that is associated to a specified virtual gateway in a
     * service mesh.
     */
    suspend fun updateGatewayRoute(block: UpdateGatewayRouteRequest.Builder.() -> Unit) = updateGatewayRoute(UpdateGatewayRouteRequest.Builder().apply(block).build())

    /**
     * Updates an existing service mesh.
     */
    suspend fun updateMesh(input: UpdateMeshRequest): UpdateMeshResponse

    /**
     * Updates an existing service mesh.
     */
    suspend fun updateMesh(block: UpdateMeshRequest.Builder.() -> Unit) = updateMesh(UpdateMeshRequest.Builder().apply(block).build())

    /**
     * Updates an existing route for a specified service mesh and virtual router.
     */
    suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse

    /**
     * Updates an existing route for a specified service mesh and virtual router.
     */
    suspend fun updateRoute(block: UpdateRouteRequest.Builder.() -> Unit) = updateRoute(UpdateRouteRequest.Builder().apply(block).build())

    /**
     * Updates an existing virtual gateway in a specified service mesh.
     */
    suspend fun updateVirtualGateway(input: UpdateVirtualGatewayRequest): UpdateVirtualGatewayResponse

    /**
     * Updates an existing virtual gateway in a specified service mesh.
     */
    suspend fun updateVirtualGateway(block: UpdateVirtualGatewayRequest.Builder.() -> Unit) = updateVirtualGateway(UpdateVirtualGatewayRequest.Builder().apply(block).build())

    /**
     * Updates an existing virtual node in a specified service mesh.
     */
    suspend fun updateVirtualNode(input: UpdateVirtualNodeRequest): UpdateVirtualNodeResponse

    /**
     * Updates an existing virtual node in a specified service mesh.
     */
    suspend fun updateVirtualNode(block: UpdateVirtualNodeRequest.Builder.() -> Unit) = updateVirtualNode(UpdateVirtualNodeRequest.Builder().apply(block).build())

    /**
     * Updates an existing virtual router in a specified service mesh.
     */
    suspend fun updateVirtualRouter(input: UpdateVirtualRouterRequest): UpdateVirtualRouterResponse

    /**
     * Updates an existing virtual router in a specified service mesh.
     */
    suspend fun updateVirtualRouter(block: UpdateVirtualRouterRequest.Builder.() -> Unit) = updateVirtualRouter(UpdateVirtualRouterRequest.Builder().apply(block).build())

    /**
     * Updates an existing virtual service in a specified service mesh.
     */
    suspend fun updateVirtualService(input: UpdateVirtualServiceRequest): UpdateVirtualServiceResponse

    /**
     * Updates an existing virtual service in a specified service mesh.
     */
    suspend fun updateVirtualService(block: UpdateVirtualServiceRequest.Builder.() -> Unit) = updateVirtualService(UpdateVirtualServiceRequest.Builder().apply(block).build())
}
