// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the specification of a virtual node.
 */
public class VirtualNodeSpec private constructor(builder: Builder) {
    /**
     * A reference to an object that represents the defaults for backends.
     */
    public val backendDefaults: aws.sdk.kotlin.services.appmesh.model.BackendDefaults? = builder.backendDefaults
    /**
     * The backends that the virtual node is expected to send outbound traffic to.
     */
    public val backends: List<Backend>? = builder.backends
    /**
     * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
     */
    public val listeners: List<Listener>? = builder.listeners
    /**
     * The inbound and outbound access logging information for the virtual node.
     */
    public val logging: aws.sdk.kotlin.services.appmesh.model.Logging? = builder.logging
    /**
     * The service discovery information for the virtual node. If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a `listener`, then you must specify service discovery information.
     */
    public val serviceDiscovery: aws.sdk.kotlin.services.appmesh.model.ServiceDiscovery? = builder.serviceDiscovery

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualNodeSpec(")
        append("backendDefaults=$backendDefaults,")
        append("backends=$backends,")
        append("listeners=$listeners,")
        append("logging=$logging,")
        append("serviceDiscovery=$serviceDiscovery)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backendDefaults?.hashCode() ?: 0
        result = 31 * result + (backends?.hashCode() ?: 0)
        result = 31 * result + (listeners?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (serviceDiscovery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualNodeSpec

        if (backendDefaults != other.backendDefaults) return false
        if (backends != other.backends) return false
        if (listeners != other.listeners) return false
        if (logging != other.logging) return false
        if (serviceDiscovery != other.serviceDiscovery) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A reference to an object that represents the defaults for backends.
         */
        public var backendDefaults: aws.sdk.kotlin.services.appmesh.model.BackendDefaults? = null
        /**
         * The backends that the virtual node is expected to send outbound traffic to.
         */
        public var backends: List<Backend>? = null
        /**
         * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
         */
        public var listeners: List<Listener>? = null
        /**
         * The inbound and outbound access logging information for the virtual node.
         */
        public var logging: aws.sdk.kotlin.services.appmesh.model.Logging? = null
        /**
         * The service discovery information for the virtual node. If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a `listener`, then you must specify service discovery information.
         */
        public var serviceDiscovery: aws.sdk.kotlin.services.appmesh.model.ServiceDiscovery? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec) : this() {
            this.backendDefaults = x.backendDefaults
            this.backends = x.backends
            this.listeners = x.listeners
            this.logging = x.logging
            this.serviceDiscovery = x.serviceDiscovery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec = VirtualNodeSpec(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.BackendDefaults] inside the given [block]
         */
        public fun backendDefaults(block: aws.sdk.kotlin.services.appmesh.model.BackendDefaults.Builder.() -> kotlin.Unit) {
            this.backendDefaults = aws.sdk.kotlin.services.appmesh.model.BackendDefaults.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.appmesh.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.appmesh.model.Logging.invoke(block)
        }
    }
}
