// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.appmesh.model.*
import aws.sdk.kotlin.services.appmesh.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "App Mesh"
public const val ServiceApiVersion: String = "2019-01-25"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultAppMeshClient(override val config: AppMeshClient.Config) : AppMeshClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a gateway route.
     *
     * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.
     *
     * For more information about gateway routes, see [Gateway routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
     */
    override suspend fun createGatewayRoute(input: CreateGatewayRouteRequest): CreateGatewayRouteResponse {
        val op = SdkHttpOperation.build<CreateGatewayRouteRequest, CreateGatewayRouteResponse> {
            serializer = CreateGatewayRouteOperationSerializer()
            deserializer = CreateGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a service mesh.
     *
     *  A service mesh is a logical boundary for network traffic between services that are represented by resources within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.
     *
     * For more information about service meshes, see [Service meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html).
     */
    override suspend fun createMesh(input: CreateMeshRequest): CreateMeshResponse {
        val op = SdkHttpOperation.build<CreateMeshRequest, CreateMeshResponse> {
            serializer = CreateMeshOperationSerializer()
            deserializer = CreateMeshOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMesh"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a route that is associated with a virtual router.
     *
     *  You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.
     *
     * For more information about routes, see [Routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html).
     */
    override suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse {
        val op = SdkHttpOperation.build<CreateRouteRequest, CreateRouteResponse> {
            serializer = CreateRouteOperationSerializer()
            deserializer = CreateRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual gateway.
     *
     * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.
     *
     * For more information about virtual gateways, see [Virtual gateways](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
     */
    override suspend fun createVirtualGateway(input: CreateVirtualGatewayRequest): CreateVirtualGatewayResponse {
        val op = SdkHttpOperation.build<CreateVirtualGatewayRequest, CreateVirtualGatewayResponse> {
            serializer = CreateVirtualGatewayOperationSerializer()
            deserializer = CreateVirtualGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVirtualGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual node within a service mesh.
     *
     *  A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).
     *
     * You define a `listener` for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a `backend`.
     *
     * The response metadata for your new virtual node contains the `arn` that is associated with the virtual node. Set this value to the full ARN; for example, `arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp`) as the `APPMESH_RESOURCE_ARN` environment variable for your task group's Envoy proxy container in your task definition or pod spec. This is then mapped to the `node.id` and `node.cluster` Envoy parameters.
     *
     * By default, App Mesh uses the name of the resource you specified in `APPMESH_RESOURCE_ARN` when Envoy is referring to itself in metrics and traces. You can override this behavior by setting the `APPMESH_RESOURCE_CLUSTER` environment variable with your own name.
     *
     * For more information about virtual nodes, see [Virtual nodes](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html). You must be using `1.15.0` or later of the Envoy image when setting these variables. For more information aboutApp Mesh Envoy variables, see [Envoy image](https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html) in the App Mesh User Guide.
     */
    override suspend fun createVirtualNode(input: CreateVirtualNodeRequest): CreateVirtualNodeResponse {
        val op = SdkHttpOperation.build<CreateVirtualNodeRequest, CreateVirtualNodeResponse> {
            serializer = CreateVirtualNodeOperationSerializer()
            deserializer = CreateVirtualNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVirtualNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual router within a service mesh.
     *
     * Specify a `listener` for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes.
     *
     * For more information about virtual routers, see [Virtual routers](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html).
     */
    override suspend fun createVirtualRouter(input: CreateVirtualRouterRequest): CreateVirtualRouterResponse {
        val op = SdkHttpOperation.build<CreateVirtualRouterRequest, CreateVirtualRouterResponse> {
            serializer = CreateVirtualRouterOperationSerializer()
            deserializer = CreateVirtualRouterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVirtualRouter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual service within a service mesh.
     *
     * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its `virtualServiceName`, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.
     *
     * For more information about virtual services, see [Virtual services](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html).
     */
    override suspend fun createVirtualService(input: CreateVirtualServiceRequest): CreateVirtualServiceResponse {
        val op = SdkHttpOperation.build<CreateVirtualServiceRequest, CreateVirtualServiceResponse> {
            serializer = CreateVirtualServiceOperationSerializer()
            deserializer = CreateVirtualServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVirtualService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing gateway route.
     */
    override suspend fun deleteGatewayRoute(input: DeleteGatewayRouteRequest): DeleteGatewayRouteResponse {
        val op = SdkHttpOperation.build<DeleteGatewayRouteRequest, DeleteGatewayRouteResponse> {
            serializer = DeleteGatewayRouteOperationSerializer()
            deserializer = DeleteGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing service mesh.
     *
     * You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh before you can delete the mesh itself.
     */
    override suspend fun deleteMesh(input: DeleteMeshRequest): DeleteMeshResponse {
        val op = SdkHttpOperation.build<DeleteMeshRequest, DeleteMeshResponse> {
            serializer = DeleteMeshOperationSerializer()
            deserializer = DeleteMeshOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMesh"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing route.
     */
    override suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse {
        val op = SdkHttpOperation.build<DeleteRouteRequest, DeleteRouteResponse> {
            serializer = DeleteRouteOperationSerializer()
            deserializer = DeleteRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.
     */
    override suspend fun deleteVirtualGateway(input: DeleteVirtualGatewayRequest): DeleteVirtualGatewayResponse {
        val op = SdkHttpOperation.build<DeleteVirtualGatewayRequest, DeleteVirtualGatewayResponse> {
            serializer = DeleteVirtualGatewayOperationSerializer()
            deserializer = DeleteVirtualGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVirtualGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing virtual node.
     *
     * You must delete any virtual services that list a virtual node as a service provider before you can delete the virtual node itself.
     */
    override suspend fun deleteVirtualNode(input: DeleteVirtualNodeRequest): DeleteVirtualNodeResponse {
        val op = SdkHttpOperation.build<DeleteVirtualNodeRequest, DeleteVirtualNodeResponse> {
            serializer = DeleteVirtualNodeOperationSerializer()
            deserializer = DeleteVirtualNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVirtualNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing virtual router.
     *
     * You must delete any routes associated with the virtual router before you can delete the router itself.
     */
    override suspend fun deleteVirtualRouter(input: DeleteVirtualRouterRequest): DeleteVirtualRouterResponse {
        val op = SdkHttpOperation.build<DeleteVirtualRouterRequest, DeleteVirtualRouterResponse> {
            serializer = DeleteVirtualRouterOperationSerializer()
            deserializer = DeleteVirtualRouterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVirtualRouter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing virtual service.
     */
    override suspend fun deleteVirtualService(input: DeleteVirtualServiceRequest): DeleteVirtualServiceResponse {
        val op = SdkHttpOperation.build<DeleteVirtualServiceRequest, DeleteVirtualServiceResponse> {
            serializer = DeleteVirtualServiceOperationSerializer()
            deserializer = DeleteVirtualServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVirtualService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing gateway route.
     */
    override suspend fun describeGatewayRoute(input: DescribeGatewayRouteRequest): DescribeGatewayRouteResponse {
        val op = SdkHttpOperation.build<DescribeGatewayRouteRequest, DescribeGatewayRouteResponse> {
            serializer = DescribeGatewayRouteOperationSerializer()
            deserializer = DescribeGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing service mesh.
     */
    override suspend fun describeMesh(input: DescribeMeshRequest): DescribeMeshResponse {
        val op = SdkHttpOperation.build<DescribeMeshRequest, DescribeMeshResponse> {
            serializer = DescribeMeshOperationSerializer()
            deserializer = DescribeMeshOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMesh"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing route.
     */
    override suspend fun describeRoute(input: DescribeRouteRequest): DescribeRouteResponse {
        val op = SdkHttpOperation.build<DescribeRouteRequest, DescribeRouteResponse> {
            serializer = DescribeRouteOperationSerializer()
            deserializer = DescribeRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing virtual gateway.
     */
    override suspend fun describeVirtualGateway(input: DescribeVirtualGatewayRequest): DescribeVirtualGatewayResponse {
        val op = SdkHttpOperation.build<DescribeVirtualGatewayRequest, DescribeVirtualGatewayResponse> {
            serializer = DescribeVirtualGatewayOperationSerializer()
            deserializer = DescribeVirtualGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVirtualGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing virtual node.
     */
    override suspend fun describeVirtualNode(input: DescribeVirtualNodeRequest): DescribeVirtualNodeResponse {
        val op = SdkHttpOperation.build<DescribeVirtualNodeRequest, DescribeVirtualNodeResponse> {
            serializer = DescribeVirtualNodeOperationSerializer()
            deserializer = DescribeVirtualNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVirtualNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing virtual router.
     */
    override suspend fun describeVirtualRouter(input: DescribeVirtualRouterRequest): DescribeVirtualRouterResponse {
        val op = SdkHttpOperation.build<DescribeVirtualRouterRequest, DescribeVirtualRouterResponse> {
            serializer = DescribeVirtualRouterOperationSerializer()
            deserializer = DescribeVirtualRouterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVirtualRouter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing virtual service.
     */
    override suspend fun describeVirtualService(input: DescribeVirtualServiceRequest): DescribeVirtualServiceResponse {
        val op = SdkHttpOperation.build<DescribeVirtualServiceRequest, DescribeVirtualServiceResponse> {
            serializer = DescribeVirtualServiceOperationSerializer()
            deserializer = DescribeVirtualServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVirtualService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     */
    override suspend fun listGatewayRoutes(input: ListGatewayRoutesRequest): ListGatewayRoutesResponse {
        val op = SdkHttpOperation.build<ListGatewayRoutesRequest, ListGatewayRoutesResponse> {
            serializer = ListGatewayRoutesOperationSerializer()
            deserializer = ListGatewayRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGatewayRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing service meshes.
     */
    override suspend fun listMeshes(input: ListMeshesRequest): ListMeshesResponse {
        val op = SdkHttpOperation.build<ListMeshesRequest, ListMeshesResponse> {
            serializer = ListMeshesOperationSerializer()
            deserializer = ListMeshesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMeshes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing routes in a service mesh.
     */
    override suspend fun listRoutes(input: ListRoutesRequest): ListRoutesResponse {
        val op = SdkHttpOperation.build<ListRoutesRequest, ListRoutesResponse> {
            serializer = ListRoutesOperationSerializer()
            deserializer = ListRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the tags for an App Mesh resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing virtual gateways in a service mesh.
     */
    override suspend fun listVirtualGateways(input: ListVirtualGatewaysRequest): ListVirtualGatewaysResponse {
        val op = SdkHttpOperation.build<ListVirtualGatewaysRequest, ListVirtualGatewaysResponse> {
            serializer = ListVirtualGatewaysOperationSerializer()
            deserializer = ListVirtualGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVirtualGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing virtual nodes.
     */
    override suspend fun listVirtualNodes(input: ListVirtualNodesRequest): ListVirtualNodesResponse {
        val op = SdkHttpOperation.build<ListVirtualNodesRequest, ListVirtualNodesResponse> {
            serializer = ListVirtualNodesOperationSerializer()
            deserializer = ListVirtualNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVirtualNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing virtual routers in a service mesh.
     */
    override suspend fun listVirtualRouters(input: ListVirtualRoutersRequest): ListVirtualRoutersResponse {
        val op = SdkHttpOperation.build<ListVirtualRoutersRequest, ListVirtualRoutersResponse> {
            serializer = ListVirtualRoutersOperationSerializer()
            deserializer = ListVirtualRoutersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVirtualRouters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing virtual services in a service mesh.
     */
    override suspend fun listVirtualServices(input: ListVirtualServicesRequest): ListVirtualServicesResponse {
        val op = SdkHttpOperation.build<ListVirtualServicesRequest, ListVirtualServicesResponse> {
            serializer = ListVirtualServicesOperationSerializer()
            deserializer = ListVirtualServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVirtualServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes specified tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
     */
    override suspend fun updateGatewayRoute(input: UpdateGatewayRouteRequest): UpdateGatewayRouteResponse {
        val op = SdkHttpOperation.build<UpdateGatewayRouteRequest, UpdateGatewayRouteResponse> {
            serializer = UpdateGatewayRouteOperationSerializer()
            deserializer = UpdateGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing service mesh.
     */
    override suspend fun updateMesh(input: UpdateMeshRequest): UpdateMeshResponse {
        val op = SdkHttpOperation.build<UpdateMeshRequest, UpdateMeshResponse> {
            serializer = UpdateMeshOperationSerializer()
            deserializer = UpdateMeshOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMesh"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing route for a specified service mesh and virtual router.
     */
    override suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse {
        val op = SdkHttpOperation.build<UpdateRouteRequest, UpdateRouteResponse> {
            serializer = UpdateRouteOperationSerializer()
            deserializer = UpdateRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing virtual gateway in a specified service mesh.
     */
    override suspend fun updateVirtualGateway(input: UpdateVirtualGatewayRequest): UpdateVirtualGatewayResponse {
        val op = SdkHttpOperation.build<UpdateVirtualGatewayRequest, UpdateVirtualGatewayResponse> {
            serializer = UpdateVirtualGatewayOperationSerializer()
            deserializer = UpdateVirtualGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVirtualGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing virtual node in a specified service mesh.
     */
    override suspend fun updateVirtualNode(input: UpdateVirtualNodeRequest): UpdateVirtualNodeResponse {
        val op = SdkHttpOperation.build<UpdateVirtualNodeRequest, UpdateVirtualNodeResponse> {
            serializer = UpdateVirtualNodeOperationSerializer()
            deserializer = UpdateVirtualNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVirtualNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing virtual router in a specified service mesh.
     */
    override suspend fun updateVirtualRouter(input: UpdateVirtualRouterRequest): UpdateVirtualRouterResponse {
        val op = SdkHttpOperation.build<UpdateVirtualRouterRequest, UpdateVirtualRouterResponse> {
            serializer = UpdateVirtualRouterOperationSerializer()
            deserializer = UpdateVirtualRouterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVirtualRouter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing virtual service in a specified service mesh.
     */
    override suspend fun updateVirtualService(input: UpdateVirtualServiceRequest): UpdateVirtualServiceResponse {
        val op = SdkHttpOperation.build<UpdateVirtualServiceRequest, UpdateVirtualServiceResponse> {
            serializer = UpdateVirtualServiceOperationSerializer()
            deserializer = UpdateVirtualServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVirtualService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appmesh"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "appmesh")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
