// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.serde

import aws.sdk.kotlin.services.appmesh.model.AppMeshException
import aws.sdk.kotlin.services.appmesh.model.DescribeGatewayRouteResponse
import aws.sdk.kotlin.services.appmesh.model.GatewayRouteData
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DescribeGatewayRouteOperationDeserializer: HttpDeserialize<DescribeGatewayRouteResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeGatewayRouteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGatewayRouteError(context, call)
        }
        val builder = DescribeGatewayRouteResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.gatewayRoute = deserializeGatewayRouteDataPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeGatewayRouteError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppMeshException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppMeshException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
