// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.serde

import aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest
import aws.sdk.kotlin.services.appmesh.model.TagRef
import aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateVirtualGatewayOperationSerializer: HttpSerialize<CreateVirtualGatewayRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateVirtualGatewayRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20190125"))
                add(PercentEncoding.Path.encode("meshes"))
                add(PercentEncoding.SmithyLabel.encode("${input.meshName}"))
                add(PercentEncoding.Path.encode("virtualGateways"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.meshOwner != null) add("meshOwner", input.meshOwner)
            }
        }

        val payload = serializeCreateVirtualGatewayOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateVirtualGatewayOperationBody(context: ExecutionContext, input: CreateVirtualGatewayRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val SPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("spec"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val VIRTUALGATEWAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualGatewayName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(SPEC_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VIRTUALGATEWAYNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.spec?.let { field(SPEC_DESCRIPTOR, it, ::serializeVirtualGatewaySpecDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagRefDocument))
                }
            }
        }
        field(VIRTUALGATEWAYNAME_DESCRIPTOR, input.virtualGatewayName)
    }
    return serializer.toByteArray()
}
