// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a local file certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see [Transport Layer Security (TLS)](https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).
 */
public class VirtualGatewayListenerTlsFileCertificate private constructor(builder: Builder) {
    /**
     * The certificate chain for the certificate.
     */
    public val certificateChain: kotlin.String = requireNotNull(builder.certificateChain) { "A non-null value must be provided for certificateChain" }
    /**
     * The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on.
     */
    public val privateKey: kotlin.String = requireNotNull(builder.privateKey) { "A non-null value must be provided for privateKey" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayListenerTlsFileCertificate(")
        append("certificateChain=$certificateChain,")
        append("privateKey=$privateKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateChain.hashCode()
        result = 31 * result + (privateKey.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualGatewayListenerTlsFileCertificate

        if (certificateChain != other.certificateChain) return false
        if (privateKey != other.privateKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certificate chain for the certificate.
         */
        public var certificateChain: kotlin.String? = null
        /**
         * The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on.
         */
        public var privateKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate) : this() {
            this.certificateChain = x.certificateChain
            this.privateKey = x.privateKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate = VirtualGatewayListenerTlsFileCertificate(this)

        internal fun correctErrors(): Builder {
            if (certificateChain == null) certificateChain = ""
            if (privateKey == null) privateKey = ""
            return this
        }
    }
}
