// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
public class UpdateVirtualNodeRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the service mesh that the virtual node resides in.
     */
    public val meshName: kotlin.String = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The new virtual node specification to apply. This overwrites the existing data.
     */
    public val spec: aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec? = builder.spec
    /**
     * The name of the virtual node to update.
     */
    public val virtualNodeName: kotlin.String = requireNotNull(builder.virtualNodeName) { "A non-null value must be provided for virtualNodeName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateVirtualNodeRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("virtualNodeName=$virtualNodeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName.hashCode())
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualNodeName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateVirtualNodeRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (virtualNodeName != other.virtualNodeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the service mesh that the virtual node resides in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The new virtual node specification to apply. This overwrites the existing data.
         */
        public var spec: aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec? = null
        /**
         * The name of the virtual node to update.
         */
        public var virtualNodeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.virtualNodeName = x.virtualNodeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeRequest = UpdateVirtualNodeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec] inside the given [block]
         */
        public fun spec(block: aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (meshName == null) meshName = ""
            if (virtualNodeName == null) virtualNodeName = ""
            return this
        }
    }
}
