// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents a route returned by a list operation.
 */
public class RouteRef private constructor(builder: Builder) {
    /**
     * The full Amazon Resource Name (ARN) for the route.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The name of the service mesh that the route resides in.
     */
    public val meshName: kotlin.String = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String = requireNotNull(builder.meshOwner) { "A non-null value must be provided for meshOwner" }
    /**
     * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val resourceOwner: kotlin.String = requireNotNull(builder.resourceOwner) { "A non-null value must be provided for resourceOwner" }
    /**
     * The name of the route.
     */
    public val routeName: kotlin.String = requireNotNull(builder.routeName) { "A non-null value must be provided for routeName" }
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    public val version: kotlin.Long = requireNotNull(builder.version) { "A non-null value must be provided for version" }
    /**
     * The virtual router that the route is associated with.
     */
    public val virtualRouterName: kotlin.String = requireNotNull(builder.virtualRouterName) { "A non-null value must be provided for virtualRouterName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.RouteRef = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RouteRef(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("routeName=$routeName,")
        append("version=$version,")
        append("virtualRouterName=$virtualRouterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (meshName.hashCode())
        result = 31 * result + (meshOwner.hashCode())
        result = 31 * result + (resourceOwner.hashCode())
        result = 31 * result + (routeName.hashCode())
        result = 31 * result + (version.hashCode())
        result = 31 * result + (virtualRouterName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RouteRef

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (routeName != other.routeName) return false
        if (version != other.version) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.RouteRef = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full Amazon Resource Name (ARN) for the route.
         */
        public var arn: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service mesh that the route resides in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var resourceOwner: kotlin.String? = null
        /**
         * The name of the route.
         */
        public var routeName: kotlin.String? = null
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        public var version: kotlin.Long? = null
        /**
         * The virtual router that the route is associated with.
         */
        public var virtualRouterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.RouteRef) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.routeName = x.routeName
            this.version = x.version
            this.virtualRouterName = x.virtualRouterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.RouteRef = RouteRef(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (meshName == null) meshName = ""
            if (meshOwner == null) meshOwner = ""
            if (resourceOwner == null) resourceOwner = ""
            if (routeName == null) routeName = ""
            if (version == null) version = 0L
            if (virtualRouterName == null) virtualRouterName = ""
            return this
        }
    }
}
