// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents metadata for a resource.
 */
public class ResourceMetadata private constructor(builder: Builder) {
    /**
     * The full Amazon Resource Name (ARN) for the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String = requireNotNull(builder.meshOwner) { "A non-null value must be provided for meshOwner" }
    /**
     * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val resourceOwner: kotlin.String = requireNotNull(builder.resourceOwner) { "A non-null value must be provided for resourceOwner" }
    /**
     * The unique identifier for the resource.
     */
    public val uid: kotlin.String = requireNotNull(builder.uid) { "A non-null value must be provided for uid" }
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    public val version: kotlin.Long = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.ResourceMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceMetadata(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("uid=$uid,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (meshOwner.hashCode())
        result = 31 * result + (resourceOwner.hashCode())
        result = 31 * result + (uid.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceMetadata

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (uid != other.uid) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.ResourceMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full Amazon Resource Name (ARN) for the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var resourceOwner: kotlin.String? = null
        /**
         * The unique identifier for the resource.
         */
        public var uid: kotlin.String? = null
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        public var version: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.ResourceMetadata) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.uid = x.uid
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.ResourceMetadata = ResourceMetadata(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (meshOwner == null) meshOwner = ""
            if (resourceOwner == null) resourceOwner = ""
            if (uid == null) uid = ""
            if (version == null) version = 0L
            return this
        }
    }
}
