// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appmesh.auth.AppMeshAuthSchemeProvider
import aws.sdk.kotlin.services.appmesh.auth.DefaultAppMeshAuthSchemeProvider
import aws.sdk.kotlin.services.appmesh.endpoints.AppMeshEndpointParameters
import aws.sdk.kotlin.services.appmesh.endpoints.AppMeshEndpointProvider
import aws.sdk.kotlin.services.appmesh.endpoints.DefaultAppMeshEndpointProvider
import aws.sdk.kotlin.services.appmesh.model.CreateGatewayRouteRequest
import aws.sdk.kotlin.services.appmesh.model.CreateGatewayRouteResponse
import aws.sdk.kotlin.services.appmesh.model.CreateMeshRequest
import aws.sdk.kotlin.services.appmesh.model.CreateMeshResponse
import aws.sdk.kotlin.services.appmesh.model.CreateRouteRequest
import aws.sdk.kotlin.services.appmesh.model.CreateRouteResponse
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayResponse
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualNodeRequest
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualNodeResponse
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualRouterRequest
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualRouterResponse
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualServiceRequest
import aws.sdk.kotlin.services.appmesh.model.CreateVirtualServiceResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteGatewayRouteRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteGatewayRouteResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteMeshRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteMeshResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteRouteRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteRouteResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualGatewayRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualGatewayResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualRouterRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualRouterResponse
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualServiceRequest
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualServiceResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeGatewayRouteRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeGatewayRouteResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeMeshRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeMeshResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeRouteRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeRouteResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualGatewayRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualGatewayResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualNodeRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualNodeResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualRouterRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualRouterResponse
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualServiceRequest
import aws.sdk.kotlin.services.appmesh.model.DescribeVirtualServiceResponse
import aws.sdk.kotlin.services.appmesh.model.ListGatewayRoutesRequest
import aws.sdk.kotlin.services.appmesh.model.ListGatewayRoutesResponse
import aws.sdk.kotlin.services.appmesh.model.ListMeshesRequest
import aws.sdk.kotlin.services.appmesh.model.ListMeshesResponse
import aws.sdk.kotlin.services.appmesh.model.ListRoutesRequest
import aws.sdk.kotlin.services.appmesh.model.ListRoutesResponse
import aws.sdk.kotlin.services.appmesh.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appmesh.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appmesh.model.ListVirtualGatewaysRequest
import aws.sdk.kotlin.services.appmesh.model.ListVirtualGatewaysResponse
import aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesRequest
import aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesResponse
import aws.sdk.kotlin.services.appmesh.model.ListVirtualRoutersRequest
import aws.sdk.kotlin.services.appmesh.model.ListVirtualRoutersResponse
import aws.sdk.kotlin.services.appmesh.model.ListVirtualServicesRequest
import aws.sdk.kotlin.services.appmesh.model.ListVirtualServicesResponse
import aws.sdk.kotlin.services.appmesh.model.TagResourceRequest
import aws.sdk.kotlin.services.appmesh.model.TagResourceResponse
import aws.sdk.kotlin.services.appmesh.model.UntagResourceRequest
import aws.sdk.kotlin.services.appmesh.model.UntagResourceResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateMeshRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateMeshResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateRouteRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateRouteResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualGatewayRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualGatewayResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualNodeResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualRouterRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualRouterResponse
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualServiceRequest
import aws.sdk.kotlin.services.appmesh.model.UpdateVirtualServiceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "App Mesh"
public const val SdkVersion: String = "1.0.67"
public const val ServiceApiVersion: String = "2019-01-25"

/**
 * App Mesh is a service mesh based on the Envoy proxy that makes it easy to monitor and control microservices. App Mesh standardizes how your microservices communicate, giving you end-to-end visibility and helping to ensure high availability for your applications.
 *
 * App Mesh gives you consistent visibility and network traffic controls for every microservice in an application. You can use App Mesh with Amazon Web Services Fargate, Amazon ECS, Amazon EKS, Kubernetes on Amazon Web Services, and Amazon EC2.
 *
 * App Mesh supports microservice applications that use service discovery naming for their components. For more information about service discovery on Amazon ECS, see [Service Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html) in the *Amazon Elastic Container Service Developer Guide*. Kubernetes `kube-dns` and `coredns` are supported. For more information, see [DNS for Services and Pods](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/) in the Kubernetes documentation.
 */
public interface AppMeshClient : SdkClient {
    /**
     * AppMeshClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppMeshClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppMesh",
                "APP_MESH",
                "app_mesh",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppMeshClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppMeshClient = DefaultAppMeshClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppMeshEndpointProvider = builder.endpointProvider ?: DefaultAppMeshEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppMeshAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppMeshAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "App Mesh"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppMeshEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppMeshAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a gateway route.
     *
     * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.
     *
     * For more information about gateway routes, see [Gateway routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
     */
    public suspend fun createGatewayRoute(input: CreateGatewayRouteRequest): CreateGatewayRouteResponse

    /**
     * Creates a service mesh.
     *
     *  A service mesh is a logical boundary for network traffic between services that are represented by resources within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.
     *
     * For more information about service meshes, see [Service meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html).
     */
    public suspend fun createMesh(input: CreateMeshRequest): CreateMeshResponse

    /**
     * Creates a route that is associated with a virtual router.
     *
     *  You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.
     *
     * For more information about routes, see [Routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html).
     */
    public suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates a virtual gateway.
     *
     * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.
     *
     * For more information about virtual gateways, see [Virtual gateways](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
     */
    public suspend fun createVirtualGateway(input: CreateVirtualGatewayRequest): CreateVirtualGatewayResponse

    /**
     * Creates a virtual node within a service mesh.
     *
     *  A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).
     *
     * You define a `listener` for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a `backend`.
     *
     * The response metadata for your new virtual node contains the `arn` that is associated with the virtual node. Set this value to the full ARN; for example, `arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp`) as the `APPMESH_RESOURCE_ARN` environment variable for your task group's Envoy proxy container in your task definition or pod spec. This is then mapped to the `node.id` and `node.cluster` Envoy parameters.
     *
     * By default, App Mesh uses the name of the resource you specified in `APPMESH_RESOURCE_ARN` when Envoy is referring to itself in metrics and traces. You can override this behavior by setting the `APPMESH_RESOURCE_CLUSTER` environment variable with your own name.
     *
     * For more information about virtual nodes, see [Virtual nodes](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html). You must be using `1.15.0` or later of the Envoy image when setting these variables. For more information aboutApp Mesh Envoy variables, see [Envoy image](https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html) in the App Mesh User Guide.
     */
    public suspend fun createVirtualNode(input: CreateVirtualNodeRequest): CreateVirtualNodeResponse

    /**
     * Creates a virtual router within a service mesh.
     *
     * Specify a `listener` for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes.
     *
     * For more information about virtual routers, see [Virtual routers](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html).
     */
    public suspend fun createVirtualRouter(input: CreateVirtualRouterRequest): CreateVirtualRouterResponse

    /**
     * Creates a virtual service within a service mesh.
     *
     * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its `virtualServiceName`, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.
     *
     * For more information about virtual services, see [Virtual services](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html).
     */
    public suspend fun createVirtualService(input: CreateVirtualServiceRequest): CreateVirtualServiceResponse

    /**
     * Deletes an existing gateway route.
     */
    public suspend fun deleteGatewayRoute(input: DeleteGatewayRouteRequest): DeleteGatewayRouteResponse

    /**
     * Deletes an existing service mesh.
     *
     * You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh before you can delete the mesh itself.
     */
    public suspend fun deleteMesh(input: DeleteMeshRequest): DeleteMeshResponse

    /**
     * Deletes an existing route.
     */
    public suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.
     */
    public suspend fun deleteVirtualGateway(input: DeleteVirtualGatewayRequest): DeleteVirtualGatewayResponse

    /**
     * Deletes an existing virtual node.
     *
     * You must delete any virtual services that list a virtual node as a service provider before you can delete the virtual node itself.
     */
    public suspend fun deleteVirtualNode(input: DeleteVirtualNodeRequest): DeleteVirtualNodeResponse

    /**
     * Deletes an existing virtual router.
     *
     * You must delete any routes associated with the virtual router before you can delete the router itself.
     */
    public suspend fun deleteVirtualRouter(input: DeleteVirtualRouterRequest): DeleteVirtualRouterResponse

    /**
     * Deletes an existing virtual service.
     */
    public suspend fun deleteVirtualService(input: DeleteVirtualServiceRequest): DeleteVirtualServiceResponse

    /**
     * Describes an existing gateway route.
     */
    public suspend fun describeGatewayRoute(input: DescribeGatewayRouteRequest): DescribeGatewayRouteResponse

    /**
     * Describes an existing service mesh.
     */
    public suspend fun describeMesh(input: DescribeMeshRequest): DescribeMeshResponse

    /**
     * Describes an existing route.
     */
    public suspend fun describeRoute(input: DescribeRouteRequest): DescribeRouteResponse

    /**
     * Describes an existing virtual gateway.
     */
    public suspend fun describeVirtualGateway(input: DescribeVirtualGatewayRequest): DescribeVirtualGatewayResponse

    /**
     * Describes an existing virtual node.
     */
    public suspend fun describeVirtualNode(input: DescribeVirtualNodeRequest): DescribeVirtualNodeResponse

    /**
     * Describes an existing virtual router.
     */
    public suspend fun describeVirtualRouter(input: DescribeVirtualRouterRequest): DescribeVirtualRouterResponse

    /**
     * Describes an existing virtual service.
     */
    public suspend fun describeVirtualService(input: DescribeVirtualServiceRequest): DescribeVirtualServiceResponse

    /**
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     */
    public suspend fun listGatewayRoutes(input: ListGatewayRoutesRequest): ListGatewayRoutesResponse

    /**
     * Returns a list of existing service meshes.
     */
    public suspend fun listMeshes(input: ListMeshesRequest = ListMeshesRequest { }): ListMeshesResponse

    /**
     * Returns a list of existing routes in a service mesh.
     */
    public suspend fun listRoutes(input: ListRoutesRequest): ListRoutesResponse

    /**
     * List the tags for an App Mesh resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of existing virtual gateways in a service mesh.
     */
    public suspend fun listVirtualGateways(input: ListVirtualGatewaysRequest): ListVirtualGatewaysResponse

    /**
     * Returns a list of existing virtual nodes.
     */
    public suspend fun listVirtualNodes(input: ListVirtualNodesRequest): ListVirtualNodesResponse

    /**
     * Returns a list of existing virtual routers in a service mesh.
     */
    public suspend fun listVirtualRouters(input: ListVirtualRoutersRequest): ListVirtualRoutersResponse

    /**
     * Returns a list of existing virtual services in a service mesh.
     */
    public suspend fun listVirtualServices(input: ListVirtualServicesRequest): ListVirtualServicesResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
     */
    public suspend fun updateGatewayRoute(input: UpdateGatewayRouteRequest): UpdateGatewayRouteResponse

    /**
     * Updates an existing service mesh.
     */
    public suspend fun updateMesh(input: UpdateMeshRequest): UpdateMeshResponse

    /**
     * Updates an existing route for a specified service mesh and virtual router.
     */
    public suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse

    /**
     * Updates an existing virtual gateway in a specified service mesh.
     */
    public suspend fun updateVirtualGateway(input: UpdateVirtualGatewayRequest): UpdateVirtualGatewayResponse

    /**
     * Updates an existing virtual node in a specified service mesh.
     */
    public suspend fun updateVirtualNode(input: UpdateVirtualNodeRequest): UpdateVirtualNodeResponse

    /**
     * Updates an existing virtual router in a specified service mesh.
     */
    public suspend fun updateVirtualRouter(input: UpdateVirtualRouterRequest): UpdateVirtualRouterResponse

    /**
     * Updates an existing virtual service in a specified service mesh.
     */
    public suspend fun updateVirtualService(input: UpdateVirtualServiceRequest): UpdateVirtualServiceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppMeshClient.withConfig(block: AppMeshClient.Config.Builder.() -> Unit): AppMeshClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppMeshClient(newConfig)
}

/**
 * Creates a gateway route.
 *
 * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.
 *
 * For more information about gateway routes, see [Gateway routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
 */
public suspend inline fun AppMeshClient.createGatewayRoute(crossinline block: CreateGatewayRouteRequest.Builder.() -> Unit): CreateGatewayRouteResponse = createGatewayRoute(CreateGatewayRouteRequest.Builder().apply(block).build())

/**
 * Creates a service mesh.
 *
 *  A service mesh is a logical boundary for network traffic between services that are represented by resources within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.
 *
 * For more information about service meshes, see [Service meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html).
 */
public suspend inline fun AppMeshClient.createMesh(crossinline block: CreateMeshRequest.Builder.() -> Unit): CreateMeshResponse = createMesh(CreateMeshRequest.Builder().apply(block).build())

/**
 * Creates a route that is associated with a virtual router.
 *
 *  You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.
 *
 * For more information about routes, see [Routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html).
 */
public suspend inline fun AppMeshClient.createRoute(crossinline block: CreateRouteRequest.Builder.() -> Unit): CreateRouteResponse = createRoute(CreateRouteRequest.Builder().apply(block).build())

/**
 * Creates a virtual gateway.
 *
 * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.
 *
 * For more information about virtual gateways, see [Virtual gateways](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
 */
public suspend inline fun AppMeshClient.createVirtualGateway(crossinline block: CreateVirtualGatewayRequest.Builder.() -> Unit): CreateVirtualGatewayResponse = createVirtualGateway(CreateVirtualGatewayRequest.Builder().apply(block).build())

/**
 * Creates a virtual node within a service mesh.
 *
 *  A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).
 *
 * You define a `listener` for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a `backend`.
 *
 * The response metadata for your new virtual node contains the `arn` that is associated with the virtual node. Set this value to the full ARN; for example, `arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp`) as the `APPMESH_RESOURCE_ARN` environment variable for your task group's Envoy proxy container in your task definition or pod spec. This is then mapped to the `node.id` and `node.cluster` Envoy parameters.
 *
 * By default, App Mesh uses the name of the resource you specified in `APPMESH_RESOURCE_ARN` when Envoy is referring to itself in metrics and traces. You can override this behavior by setting the `APPMESH_RESOURCE_CLUSTER` environment variable with your own name.
 *
 * For more information about virtual nodes, see [Virtual nodes](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html). You must be using `1.15.0` or later of the Envoy image when setting these variables. For more information aboutApp Mesh Envoy variables, see [Envoy image](https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html) in the App Mesh User Guide.
 */
public suspend inline fun AppMeshClient.createVirtualNode(crossinline block: CreateVirtualNodeRequest.Builder.() -> Unit): CreateVirtualNodeResponse = createVirtualNode(CreateVirtualNodeRequest.Builder().apply(block).build())

/**
 * Creates a virtual router within a service mesh.
 *
 * Specify a `listener` for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes.
 *
 * For more information about virtual routers, see [Virtual routers](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html).
 */
public suspend inline fun AppMeshClient.createVirtualRouter(crossinline block: CreateVirtualRouterRequest.Builder.() -> Unit): CreateVirtualRouterResponse = createVirtualRouter(CreateVirtualRouterRequest.Builder().apply(block).build())

/**
 * Creates a virtual service within a service mesh.
 *
 * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its `virtualServiceName`, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.
 *
 * For more information about virtual services, see [Virtual services](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html).
 */
public suspend inline fun AppMeshClient.createVirtualService(crossinline block: CreateVirtualServiceRequest.Builder.() -> Unit): CreateVirtualServiceResponse = createVirtualService(CreateVirtualServiceRequest.Builder().apply(block).build())

/**
 * Deletes an existing gateway route.
 */
public suspend inline fun AppMeshClient.deleteGatewayRoute(crossinline block: DeleteGatewayRouteRequest.Builder.() -> Unit): DeleteGatewayRouteResponse = deleteGatewayRoute(DeleteGatewayRouteRequest.Builder().apply(block).build())

/**
 * Deletes an existing service mesh.
 *
 * You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh before you can delete the mesh itself.
 */
public suspend inline fun AppMeshClient.deleteMesh(crossinline block: DeleteMeshRequest.Builder.() -> Unit): DeleteMeshResponse = deleteMesh(DeleteMeshRequest.Builder().apply(block).build())

/**
 * Deletes an existing route.
 */
public suspend inline fun AppMeshClient.deleteRoute(crossinline block: DeleteRouteRequest.Builder.() -> Unit): DeleteRouteResponse = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

/**
 * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.
 */
public suspend inline fun AppMeshClient.deleteVirtualGateway(crossinline block: DeleteVirtualGatewayRequest.Builder.() -> Unit): DeleteVirtualGatewayResponse = deleteVirtualGateway(DeleteVirtualGatewayRequest.Builder().apply(block).build())

/**
 * Deletes an existing virtual node.
 *
 * You must delete any virtual services that list a virtual node as a service provider before you can delete the virtual node itself.
 */
public suspend inline fun AppMeshClient.deleteVirtualNode(crossinline block: DeleteVirtualNodeRequest.Builder.() -> Unit): DeleteVirtualNodeResponse = deleteVirtualNode(DeleteVirtualNodeRequest.Builder().apply(block).build())

/**
 * Deletes an existing virtual router.
 *
 * You must delete any routes associated with the virtual router before you can delete the router itself.
 */
public suspend inline fun AppMeshClient.deleteVirtualRouter(crossinline block: DeleteVirtualRouterRequest.Builder.() -> Unit): DeleteVirtualRouterResponse = deleteVirtualRouter(DeleteVirtualRouterRequest.Builder().apply(block).build())

/**
 * Deletes an existing virtual service.
 */
public suspend inline fun AppMeshClient.deleteVirtualService(crossinline block: DeleteVirtualServiceRequest.Builder.() -> Unit): DeleteVirtualServiceResponse = deleteVirtualService(DeleteVirtualServiceRequest.Builder().apply(block).build())

/**
 * Describes an existing gateway route.
 */
public suspend inline fun AppMeshClient.describeGatewayRoute(crossinline block: DescribeGatewayRouteRequest.Builder.() -> Unit): DescribeGatewayRouteResponse = describeGatewayRoute(DescribeGatewayRouteRequest.Builder().apply(block).build())

/**
 * Describes an existing service mesh.
 */
public suspend inline fun AppMeshClient.describeMesh(crossinline block: DescribeMeshRequest.Builder.() -> Unit): DescribeMeshResponse = describeMesh(DescribeMeshRequest.Builder().apply(block).build())

/**
 * Describes an existing route.
 */
public suspend inline fun AppMeshClient.describeRoute(crossinline block: DescribeRouteRequest.Builder.() -> Unit): DescribeRouteResponse = describeRoute(DescribeRouteRequest.Builder().apply(block).build())

/**
 * Describes an existing virtual gateway.
 */
public suspend inline fun AppMeshClient.describeVirtualGateway(crossinline block: DescribeVirtualGatewayRequest.Builder.() -> Unit): DescribeVirtualGatewayResponse = describeVirtualGateway(DescribeVirtualGatewayRequest.Builder().apply(block).build())

/**
 * Describes an existing virtual node.
 */
public suspend inline fun AppMeshClient.describeVirtualNode(crossinline block: DescribeVirtualNodeRequest.Builder.() -> Unit): DescribeVirtualNodeResponse = describeVirtualNode(DescribeVirtualNodeRequest.Builder().apply(block).build())

/**
 * Describes an existing virtual router.
 */
public suspend inline fun AppMeshClient.describeVirtualRouter(crossinline block: DescribeVirtualRouterRequest.Builder.() -> Unit): DescribeVirtualRouterResponse = describeVirtualRouter(DescribeVirtualRouterRequest.Builder().apply(block).build())

/**
 * Describes an existing virtual service.
 */
public suspend inline fun AppMeshClient.describeVirtualService(crossinline block: DescribeVirtualServiceRequest.Builder.() -> Unit): DescribeVirtualServiceResponse = describeVirtualService(DescribeVirtualServiceRequest.Builder().apply(block).build())

/**
 * Returns a list of existing gateway routes that are associated to a virtual gateway.
 */
public suspend inline fun AppMeshClient.listGatewayRoutes(crossinline block: ListGatewayRoutesRequest.Builder.() -> Unit): ListGatewayRoutesResponse = listGatewayRoutes(ListGatewayRoutesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing service meshes.
 */
public suspend inline fun AppMeshClient.listMeshes(crossinline block: ListMeshesRequest.Builder.() -> Unit): ListMeshesResponse = listMeshes(ListMeshesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing routes in a service mesh.
 */
public suspend inline fun AppMeshClient.listRoutes(crossinline block: ListRoutesRequest.Builder.() -> Unit): ListRoutesResponse = listRoutes(ListRoutesRequest.Builder().apply(block).build())

/**
 * List the tags for an App Mesh resource.
 */
public suspend inline fun AppMeshClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of existing virtual gateways in a service mesh.
 */
public suspend inline fun AppMeshClient.listVirtualGateways(crossinline block: ListVirtualGatewaysRequest.Builder.() -> Unit): ListVirtualGatewaysResponse = listVirtualGateways(ListVirtualGatewaysRequest.Builder().apply(block).build())

/**
 * Returns a list of existing virtual nodes.
 */
public suspend inline fun AppMeshClient.listVirtualNodes(crossinline block: ListVirtualNodesRequest.Builder.() -> Unit): ListVirtualNodesResponse = listVirtualNodes(ListVirtualNodesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing virtual routers in a service mesh.
 */
public suspend inline fun AppMeshClient.listVirtualRouters(crossinline block: ListVirtualRoutersRequest.Builder.() -> Unit): ListVirtualRoutersResponse = listVirtualRouters(ListVirtualRoutersRequest.Builder().apply(block).build())

/**
 * Returns a list of existing virtual services in a service mesh.
 */
public suspend inline fun AppMeshClient.listVirtualServices(crossinline block: ListVirtualServicesRequest.Builder.() -> Unit): ListVirtualServicesResponse = listVirtualServices(ListVirtualServicesRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
 */
public suspend inline fun AppMeshClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun AppMeshClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
 */
public suspend inline fun AppMeshClient.updateGatewayRoute(crossinline block: UpdateGatewayRouteRequest.Builder.() -> Unit): UpdateGatewayRouteResponse = updateGatewayRoute(UpdateGatewayRouteRequest.Builder().apply(block).build())

/**
 * Updates an existing service mesh.
 */
public suspend inline fun AppMeshClient.updateMesh(crossinline block: UpdateMeshRequest.Builder.() -> Unit): UpdateMeshResponse = updateMesh(UpdateMeshRequest.Builder().apply(block).build())

/**
 * Updates an existing route for a specified service mesh and virtual router.
 */
public suspend inline fun AppMeshClient.updateRoute(crossinline block: UpdateRouteRequest.Builder.() -> Unit): UpdateRouteResponse = updateRoute(UpdateRouteRequest.Builder().apply(block).build())

/**
 * Updates an existing virtual gateway in a specified service mesh.
 */
public suspend inline fun AppMeshClient.updateVirtualGateway(crossinline block: UpdateVirtualGatewayRequest.Builder.() -> Unit): UpdateVirtualGatewayResponse = updateVirtualGateway(UpdateVirtualGatewayRequest.Builder().apply(block).build())

/**
 * Updates an existing virtual node in a specified service mesh.
 */
public suspend inline fun AppMeshClient.updateVirtualNode(crossinline block: UpdateVirtualNodeRequest.Builder.() -> Unit): UpdateVirtualNodeResponse = updateVirtualNode(UpdateVirtualNodeRequest.Builder().apply(block).build())

/**
 * Updates an existing virtual router in a specified service mesh.
 */
public suspend inline fun AppMeshClient.updateVirtualRouter(crossinline block: UpdateVirtualRouterRequest.Builder.() -> Unit): UpdateVirtualRouterResponse = updateVirtualRouter(UpdateVirtualRouterRequest.Builder().apply(block).build())

/**
 * Updates an existing virtual service in a specified service mesh.
 */
public suspend inline fun AppMeshClient.updateVirtualService(crossinline block: UpdateVirtualServiceRequest.Builder.() -> Unit): UpdateVirtualServiceResponse = updateVirtualService(UpdateVirtualServiceRequest.Builder().apply(block).build())
