// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents a virtual router returned by a list operation.
 */
public class VirtualRouterRef private constructor(builder: Builder) {
    /**
     * The full Amazon Resource Name (ARN) for the virtual router.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the service mesh that the virtual router resides in.
     */
    public val meshName: kotlin.String? = builder.meshName
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val resourceOwner: kotlin.String? = builder.resourceOwner
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    public val version: kotlin.Long? = builder.version
    /**
     * The name of the virtual router.
     */
    public val virtualRouterName: kotlin.String? = builder.virtualRouterName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.VirtualRouterRef = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualRouterRef(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("version=$version,")
        append("virtualRouterName=$virtualRouterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualRouterRef

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (version != other.version) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.VirtualRouterRef = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full Amazon Resource Name (ARN) for the virtual router.
         */
        public var arn: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service mesh that the virtual router resides in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var resourceOwner: kotlin.String? = null
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        public var version: kotlin.Long? = null
        /**
         * The name of the virtual router.
         */
        public var virtualRouterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.VirtualRouterRef) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.version = x.version
            this.virtualRouterName = x.virtualRouterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.VirtualRouterRef = VirtualRouterRef(this)
    }
}
