// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
public class UpdateRouteRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the service mesh that the route resides in.
     */
    public val meshName: kotlin.String? = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The name of the route to update.
     */
    public val routeName: kotlin.String? = requireNotNull(builder.routeName) { "A non-null value must be provided for routeName" }
    /**
     * The new route specification to apply. This overwrites the existing data.
     */
    public val spec: aws.sdk.kotlin.services.appmesh.model.RouteSpec? = builder.spec
    /**
     * The name of the virtual router that the route is associated with.
     */
    public val virtualRouterName: kotlin.String? = requireNotNull(builder.virtualRouterName) { "A non-null value must be provided for virtualRouterName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.UpdateRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRouteRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("routeName=$routeName,")
        append("spec=$spec,")
        append("virtualRouterName=$virtualRouterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (routeName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRouteRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (routeName != other.routeName) return false
        if (spec != other.spec) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.UpdateRouteRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the service mesh that the route resides in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The name of the route to update.
         */
        public var routeName: kotlin.String? = null
        /**
         * The new route specification to apply. This overwrites the existing data.
         */
        public var spec: aws.sdk.kotlin.services.appmesh.model.RouteSpec? = null
        /**
         * The name of the virtual router that the route is associated with.
         */
        public var virtualRouterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.UpdateRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.routeName = x.routeName
            this.spec = x.spec
            this.virtualRouterName = x.virtualRouterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.UpdateRouteRequest = UpdateRouteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.RouteSpec] inside the given [block]
         */
        public fun spec(block: aws.sdk.kotlin.services.appmesh.model.RouteSpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.RouteSpec.invoke(block)
        }
    }
}
