// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
public class ListVirtualNodesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results returned by `ListVirtualNodes` in paginated output. When you use this parameter, `ListVirtualNodes` returns only `limit` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListVirtualNodes` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListVirtualNodes` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The name of the service mesh to list virtual nodes in.
     */
    public val meshName: kotlin.String? = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The `nextToken` value returned from a previous paginated `ListVirtualNodes` request where `limit` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListVirtualNodesRequest(")
        append("limit=$limit,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListVirtualNodesRequest

        if (limit != other.limit) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results returned by `ListVirtualNodes` in paginated output. When you use this parameter, `ListVirtualNodes` returns only `limit` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListVirtualNodes` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListVirtualNodes` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var limit: kotlin.Int? = null
        /**
         * The name of the service mesh to list virtual nodes in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListVirtualNodes` request where `limit` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesRequest) : this() {
            this.limit = x.limit
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.ListVirtualNodesRequest = ListVirtualNodesRequest(this)
    }
}
