// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the criteria for determining a request match.
 */
public class HttpGatewayRouteMatch private constructor(builder: Builder) {
    /**
     * The client request headers to match on.
     */
    public val headers: List<HttpGatewayRouteHeader>? = builder.headers
    /**
     * The host name to match on.
     */
    public val hostname: aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch? = builder.hostname
    /**
     * The method to match on.
     */
    public val method: aws.sdk.kotlin.services.appmesh.model.HttpMethod? = builder.method
    /**
     * The path to match on.
     */
    public val path: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch? = builder.path
    /**
     * The port number to match on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Specifies the path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is `my-service.local` and you want the route to match requests to `my-service.local/metrics`, your prefix should be `/metrics`.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The query parameter to match on.
     */
    public val queryParameters: List<HttpQueryParameter>? = builder.queryParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.HttpGatewayRouteMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpGatewayRouteMatch(")
        append("headers=$headers,")
        append("hostname=$hostname,")
        append("method=$method,")
        append("path=$path,")
        append("port=$port,")
        append("prefix=$prefix,")
        append("queryParameters=$queryParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers?.hashCode() ?: 0
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpGatewayRouteMatch

        if (headers != other.headers) return false
        if (hostname != other.hostname) return false
        if (method != other.method) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (prefix != other.prefix) return false
        if (queryParameters != other.queryParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.HttpGatewayRouteMatch = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The client request headers to match on.
         */
        public var headers: List<HttpGatewayRouteHeader>? = null
        /**
         * The host name to match on.
         */
        public var hostname: aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch? = null
        /**
         * The method to match on.
         */
        public var method: aws.sdk.kotlin.services.appmesh.model.HttpMethod? = null
        /**
         * The path to match on.
         */
        public var path: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch? = null
        /**
         * The port number to match on.
         */
        public var port: kotlin.Int? = null
        /**
         * Specifies the path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is `my-service.local` and you want the route to match requests to `my-service.local/metrics`, your prefix should be `/metrics`.
         */
        public var prefix: kotlin.String? = null
        /**
         * The query parameter to match on.
         */
        public var queryParameters: List<HttpQueryParameter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.HttpGatewayRouteMatch) : this() {
            this.headers = x.headers
            this.hostname = x.hostname
            this.method = x.method
            this.path = x.path
            this.port = x.port
            this.prefix = x.prefix
            this.queryParameters = x.queryParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.HttpGatewayRouteMatch = HttpGatewayRouteMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch] inside the given [block]
         */
        public fun hostname(block: aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch.Builder.() -> kotlin.Unit) {
            this.hostname = aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpPathMatch] inside the given [block]
         */
        public fun path(block: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch.Builder.() -> kotlin.Unit) {
            this.path = aws.sdk.kotlin.services.appmesh.model.HttpPathMatch.invoke(block)
        }
    }
}
