// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



public class CreateVirtualGatewayRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the service mesh to create the virtual gateway in.
     */
    public val meshName: kotlin.String? = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The virtual gateway specification to apply.
     */
    public val spec: aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec? = builder.spec
    /**
     * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val tags: List<TagRef>? = builder.tags
    /**
     * The name to use for the virtual gateway.
     */
    public val virtualGatewayName: kotlin.String? = builder.virtualGatewayName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVirtualGatewayRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("tags=$tags,")
        append("virtualGatewayName=$virtualGatewayName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVirtualGatewayRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (tags != other.tags) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the service mesh to create the virtual gateway in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The virtual gateway specification to apply.
         */
        public var spec: aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec? = null
        /**
         * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var tags: List<TagRef>? = null
        /**
         * The name to use for the virtual gateway.
         */
        public var virtualGatewayName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.tags = x.tags
            this.virtualGatewayName = x.virtualGatewayName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.CreateVirtualGatewayRequest = CreateVirtualGatewayRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec] inside the given [block]
         */
        public fun spec(block: aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec.invoke(block)
        }
    }
}
