// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
public class CreateRouteRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the service mesh to create the route in.
     */
    public val meshName: kotlin.String? = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The name to use for the route.
     */
    public val routeName: kotlin.String? = builder.routeName
    /**
     * The route specification to apply.
     */
    public val spec: aws.sdk.kotlin.services.appmesh.model.RouteSpec? = builder.spec
    /**
     * Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val tags: List<TagRef>? = builder.tags
    /**
     * The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.
     */
    public val virtualRouterName: kotlin.String? = requireNotNull(builder.virtualRouterName) { "A non-null value must be provided for virtualRouterName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.CreateRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("routeName=$routeName,")
        append("spec=$spec,")
        append("tags=$tags,")
        append("virtualRouterName=$virtualRouterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (routeName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (routeName != other.routeName) return false
        if (spec != other.spec) return false
        if (tags != other.tags) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.CreateRouteRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the service mesh to create the route in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The name to use for the route.
         */
        public var routeName: kotlin.String? = null
        /**
         * The route specification to apply.
         */
        public var spec: aws.sdk.kotlin.services.appmesh.model.RouteSpec? = null
        /**
         * Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var tags: List<TagRef>? = null
        /**
         * The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.
         */
        public var virtualRouterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.CreateRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.routeName = x.routeName
            this.spec = x.spec
            this.tags = x.tags
            this.virtualRouterName = x.virtualRouterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.CreateRouteRequest = CreateRouteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.RouteSpec] inside the given [block]
         */
        public fun spec(block: aws.sdk.kotlin.services.appmesh.model.RouteSpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.RouteSpec.invoke(block)
        }
    }
}
