// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.paginators

import aws.sdk.kotlin.services.appmesh.AppMeshClient
import aws.sdk.kotlin.services.appmesh.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appmesh.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appmesh.model.TagRef
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun AppMeshClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun AppMeshClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [TagRef]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TagRef]
 */
@JvmName("listTagsForResourceResponseTagRef")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<TagRef> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
