// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a gateway route returned by a describe operation.
 */
class GatewayRouteData private constructor(builder: Builder) {
    /**
     * The name of the gateway route.
     */
    val gatewayRouteName: kotlin.String? = builder.gatewayRouteName
    /**
     * The name of the service mesh that the resource resides in.
     */
    val meshName: kotlin.String? = builder.meshName
    /**
     * An object that represents metadata for a resource.
     */
    val metadata: aws.sdk.kotlin.services.appmesh.model.ResourceMetadata? = builder.metadata
    /**
     * The specifications of the gateway route.
     */
    val spec: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec? = builder.spec
    /**
     * The status of the gateway route.
     */
    val status: aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus? = builder.status
    /**
     * The virtual gateway that the gateway route is associated with.
     */
    val virtualGatewayName: kotlin.String? = builder.virtualGatewayName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.GatewayRouteData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayRouteData(")
        append("gatewayRouteName=$gatewayRouteName,")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayRouteName?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayRouteData

        if (gatewayRouteName != other.gatewayRouteName) return false
        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.GatewayRouteData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the gateway route.
         */
        var gatewayRouteName: kotlin.String? = null
        /**
         * The name of the service mesh that the resource resides in.
         */
        var meshName: kotlin.String? = null
        /**
         * An object that represents metadata for a resource.
         */
        var metadata: aws.sdk.kotlin.services.appmesh.model.ResourceMetadata? = null
        /**
         * The specifications of the gateway route.
         */
        var spec: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec? = null
        /**
         * The status of the gateway route.
         */
        var status: aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus? = null
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        var virtualGatewayName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.GatewayRouteData) : this() {
            this.gatewayRouteName = x.gatewayRouteName
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualGatewayName = x.virtualGatewayName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.GatewayRouteData = GatewayRouteData(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: aws.sdk.kotlin.services.appmesh.model.ResourceMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.appmesh.model.ResourceMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec] inside the given [block]
         */
        fun spec(block: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus.invoke(block)
        }
    }
}
