// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.serde

import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.Tier
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeComponentConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeComponentConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeComponentConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeComponentConfigurationError(context, call, payload)
        }
        val builder = DescribeComponentConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeComponentConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeComponentConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeComponentConfigurationOperationBody(builder: DescribeComponentConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComponentConfiguration"))
    val MONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Monitor"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Tier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTCONFIGURATION_DESCRIPTOR)
        field(MONITOR_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTCONFIGURATION_DESCRIPTOR.index -> builder.componentConfiguration = deserializeString()
                MONITOR_DESCRIPTOR.index -> builder.monitor = deserializeBoolean()
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString().let { Tier.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
