// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



public class UpdateComponentConfigurationRequest private constructor(builder: Builder) {
    /**
     * Automatically configures the component by applying the recommended configurations.
     */
    public val autoConfigEnabled: kotlin.Boolean? = builder.autoConfigEnabled
    /**
     * The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see [Working with JSON](https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html). You can send a request to `DescribeComponentConfigurationRecommendation` to see the recommended configuration for a component. For the complete format of the component configuration file, see [Component Configuration](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html).
     */
    public val componentConfiguration: kotlin.String? = builder.componentConfiguration
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * Indicates whether the application component is monitored.
     */
    public val monitor: kotlin.Boolean? = builder.monitor
    /**
     * The name of the resource group.
     */
    public val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * The tier of the application component.
     */
    public val tier: aws.sdk.kotlin.services.applicationinsights.model.Tier? = builder.tier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateComponentConfigurationRequest(")
        append("autoConfigEnabled=$autoConfigEnabled,")
        append("componentConfiguration=$componentConfiguration,")
        append("componentName=$componentName,")
        append("monitor=$monitor,")
        append("resourceGroupName=$resourceGroupName,")
        append("tier=$tier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoConfigEnabled?.hashCode() ?: 0
        result = 31 * result + (componentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (monitor?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateComponentConfigurationRequest

        if (autoConfigEnabled != other.autoConfigEnabled) return false
        if (componentConfiguration != other.componentConfiguration) return false
        if (componentName != other.componentName) return false
        if (monitor != other.monitor) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (tier != other.tier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Automatically configures the component by applying the recommended configurations.
         */
        public var autoConfigEnabled: kotlin.Boolean? = null
        /**
         * The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see [Working with JSON](https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html). You can send a request to `DescribeComponentConfigurationRecommendation` to see the recommended configuration for a component. For the complete format of the component configuration file, see [Component Configuration](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html).
         */
        public var componentConfiguration: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * Indicates whether the application component is monitored.
         */
        public var monitor: kotlin.Boolean? = null
        /**
         * The name of the resource group.
         */
        public var resourceGroupName: kotlin.String? = null
        /**
         * The tier of the application component.
         */
        public var tier: aws.sdk.kotlin.services.applicationinsights.model.Tier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest) : this() {
            this.autoConfigEnabled = x.autoConfigEnabled
            this.componentConfiguration = x.componentConfiguration
            this.componentName = x.componentName
            this.monitor = x.monitor
            this.resourceGroupName = x.resourceGroupName
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest = UpdateComponentConfigurationRequest(this)
    }
}
