// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * Describes the status of the application.
 */
class ApplicationInfo private constructor(builder: Builder) {
    /**
     * Indicates whether auto-configuration is turned on for this application.
     */
    val autoConfigEnabled: kotlin.Boolean? = builder.autoConfigEnabled
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as `instance terminated`, `failed deployment`, and others.
     */
    val cweMonitorEnabled: kotlin.Boolean? = builder.cweMonitorEnabled
    /**
     * The method used by Application Insights to onboard your resources.
     */
    val discoveryType: aws.sdk.kotlin.services.applicationinsights.model.DiscoveryType? = builder.discoveryType
    /**
     * The lifecycle of the application.
     */
    val lifeCycle: kotlin.String? = builder.lifeCycle
    /**
     * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application.
     */
    val opsCenterEnabled: kotlin.Boolean? = builder.opsCenterEnabled
    /**
     * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates.
     */
    val opsItemSnsTopicArn: kotlin.String? = builder.opsItemSnsTopicArn
    /**
     * The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:
     * + “Configuring application, detected 1 Errors, 3 Warnings”
     * + “Configuring application, detected 1 Unconfigured Components”
     */
    val remarks: kotlin.String? = builder.remarks
    /**
     * The name of the resource group used for the application.
     */
    val resourceGroupName: kotlin.String? = builder.resourceGroupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationInfo(")
        append("autoConfigEnabled=$autoConfigEnabled,")
        append("cweMonitorEnabled=$cweMonitorEnabled,")
        append("discoveryType=$discoveryType,")
        append("lifeCycle=$lifeCycle,")
        append("opsCenterEnabled=$opsCenterEnabled,")
        append("opsItemSnsTopicArn=$opsItemSnsTopicArn,")
        append("remarks=$remarks,")
        append("resourceGroupName=$resourceGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoConfigEnabled?.hashCode() ?: 0
        result = 31 * result + (cweMonitorEnabled?.hashCode() ?: 0)
        result = 31 * result + (discoveryType?.hashCode() ?: 0)
        result = 31 * result + (lifeCycle?.hashCode() ?: 0)
        result = 31 * result + (opsCenterEnabled?.hashCode() ?: 0)
        result = 31 * result + (opsItemSnsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (remarks?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationInfo

        if (autoConfigEnabled != other.autoConfigEnabled) return false
        if (cweMonitorEnabled != other.cweMonitorEnabled) return false
        if (discoveryType != other.discoveryType) return false
        if (lifeCycle != other.lifeCycle) return false
        if (opsCenterEnabled != other.opsCenterEnabled) return false
        if (opsItemSnsTopicArn != other.opsItemSnsTopicArn) return false
        if (remarks != other.remarks) return false
        if (resourceGroupName != other.resourceGroupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether auto-configuration is turned on for this application.
         */
        var autoConfigEnabled: kotlin.Boolean? = null
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as `instance terminated`, `failed deployment`, and others.
         */
        var cweMonitorEnabled: kotlin.Boolean? = null
        /**
         * The method used by Application Insights to onboard your resources.
         */
        var discoveryType: aws.sdk.kotlin.services.applicationinsights.model.DiscoveryType? = null
        /**
         * The lifecycle of the application.
         */
        var lifeCycle: kotlin.String? = null
        /**
         * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application.
         */
        var opsCenterEnabled: kotlin.Boolean? = null
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates.
         */
        var opsItemSnsTopicArn: kotlin.String? = null
        /**
         * The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:
         * + “Configuring application, detected 1 Errors, 3 Warnings”
         * + “Configuring application, detected 1 Unconfigured Components”
         */
        var remarks: kotlin.String? = null
        /**
         * The name of the resource group used for the application.
         */
        var resourceGroupName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo) : this() {
            this.autoConfigEnabled = x.autoConfigEnabled
            this.cweMonitorEnabled = x.cweMonitorEnabled
            this.discoveryType = x.discoveryType
            this.lifeCycle = x.lifeCycle
            this.opsCenterEnabled = x.opsCenterEnabled
            this.opsItemSnsTopicArn = x.opsItemSnsTopicArn
            this.remarks = x.remarks
            this.resourceGroupName = x.resourceGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = ApplicationInfo(this)
    }
}
