// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * Describes a standalone resource or similarly grouped resources that the application is made up of.
 */
class ApplicationComponent private constructor(builder: Builder) {
    /**
     * The name of the component.
     */
    val componentName: kotlin.String? = builder.componentName
    /**
     * If logging is supported for the resource type, indicates whether the component has configured logs to be monitored.
     */
    val componentRemarks: kotlin.String? = builder.componentRemarks
    /**
     * Workloads detected in the application component.
     */
    val detectedWorkload: Map<String, Map<String, String>>? = builder.detectedWorkload
    /**
     * Indicates whether the application component is monitored.
     */
    val monitor: kotlin.Boolean? = builder.monitor
    /**
     * The operating system of the component.
     */
    val osType: aws.sdk.kotlin.services.applicationinsights.model.OsType? = builder.osType
    /**
     * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * The stack tier of the application component.
     */
    val tier: aws.sdk.kotlin.services.applicationinsights.model.Tier? = builder.tier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.ApplicationComponent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationComponent(")
        append("componentName=$componentName,")
        append("componentRemarks=$componentRemarks,")
        append("detectedWorkload=$detectedWorkload,")
        append("monitor=$monitor,")
        append("osType=$osType,")
        append("resourceType=$resourceType,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentRemarks?.hashCode() ?: 0)
        result = 31 * result + (detectedWorkload?.hashCode() ?: 0)
        result = 31 * result + (monitor?.hashCode() ?: 0)
        result = 31 * result + (osType?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationComponent

        if (componentName != other.componentName) return false
        if (componentRemarks != other.componentRemarks) return false
        if (detectedWorkload != other.detectedWorkload) return false
        if (monitor != other.monitor) return false
        if (osType != other.osType) return false
        if (resourceType != other.resourceType) return false
        if (tier != other.tier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.ApplicationComponent = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the component.
         */
        var componentName: kotlin.String? = null
        /**
         * If logging is supported for the resource type, indicates whether the component has configured logs to be monitored.
         */
        var componentRemarks: kotlin.String? = null
        /**
         * Workloads detected in the application component.
         */
        var detectedWorkload: Map<String, Map<String, String>>? = null
        /**
         * Indicates whether the application component is monitored.
         */
        var monitor: kotlin.Boolean? = null
        /**
         * The operating system of the component.
         */
        var osType: aws.sdk.kotlin.services.applicationinsights.model.OsType? = null
        /**
         * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.
         */
        var resourceType: kotlin.String? = null
        /**
         * The stack tier of the application component.
         */
        var tier: aws.sdk.kotlin.services.applicationinsights.model.Tier? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.ApplicationComponent) : this() {
            this.componentName = x.componentName
            this.componentRemarks = x.componentRemarks
            this.detectedWorkload = x.detectedWorkload
            this.monitor = x.monitor
            this.osType = x.osType
            this.resourceType = x.resourceType
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.ApplicationComponent = ApplicationComponent(this)
    }
}
