// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationcostprofiler.model.ApplicationCostProfilerException
import aws.sdk.kotlin.services.applicationcostprofiler.model.Format
import aws.sdk.kotlin.services.applicationcostprofiler.model.GetReportDefinitionResponse
import aws.sdk.kotlin.services.applicationcostprofiler.model.ReportFrequency
import aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetReportDefinitionOperationDeserializer: HttpDeserialize<GetReportDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetReportDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwGetReportDefinitionError(context, response)
        }
        val builder = GetReportDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetReportDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetReportDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationCostProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationCostProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReportDefinitionOperationBody(builder: GetReportDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESTINATIONS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destinationS3Location"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("format"))
    val LASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdated"))
    val REPORTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportDescription"))
    val REPORTFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportFrequency"))
    val REPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DESTINATIONS3LOCATION_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(LASTUPDATED_DESCRIPTOR)
        field(REPORTDESCRIPTION_DESCRIPTOR)
        field(REPORTFREQUENCY_DESCRIPTOR)
        field(REPORTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESTINATIONS3LOCATION_DESCRIPTOR.index -> builder.destinationS3Location = deserializeS3LocationDocument(deserializer)
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString().let { Format.fromValue(it) }
                LASTUPDATED_DESCRIPTOR.index -> builder.lastUpdated = deserializeString().let { Instant.fromEpochSeconds(it) }
                REPORTDESCRIPTION_DESCRIPTOR.index -> builder.reportDescription = deserializeString()
                REPORTFREQUENCY_DESCRIPTOR.index -> builder.reportFrequency = deserializeString().let { ReportFrequency.fromValue(it) }
                REPORTID_DESCRIPTOR.index -> builder.reportId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
