// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.serde

import aws.sdk.kotlin.services.applicationcostprofiler.model.ApplicationCostProfilerException
import aws.sdk.kotlin.services.applicationcostprofiler.model.Format
import aws.sdk.kotlin.services.applicationcostprofiler.model.GetReportDefinitionResponse
import aws.sdk.kotlin.services.applicationcostprofiler.model.ReportFrequency
import aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetReportDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<GetReportDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetReportDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetReportDefinitionError(context, call, payload)
        }
        val builder = GetReportDefinitionResponse.Builder()

        if (payload != null) {
            deserializeGetReportDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetReportDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationCostProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApplicationCostProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReportDefinitionOperationBody(builder: GetReportDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESTINATIONS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destinationS3Location"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("format"))
    val LASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdated"))
    val REPORTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportDescription"))
    val REPORTFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("reportFrequency"))
    val REPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DESTINATIONS3LOCATION_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(LASTUPDATED_DESCRIPTOR)
        field(REPORTDESCRIPTION_DESCRIPTOR)
        field(REPORTFREQUENCY_DESCRIPTOR)
        field(REPORTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATIONS3LOCATION_DESCRIPTOR.index -> builder.destinationS3Location = deserializeS3LocationDocument(deserializer)
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString().let { Format.fromValue(it) }
                LASTUPDATED_DESCRIPTOR.index -> builder.lastUpdated = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                REPORTDESCRIPTION_DESCRIPTOR.index -> builder.reportDescription = deserializeString()
                REPORTFREQUENCY_DESCRIPTOR.index -> builder.reportFrequency = deserializeString().let { ReportFrequency.fromValue(it) }
                REPORTID_DESCRIPTOR.index -> builder.reportId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
