// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.paginators

import aws.sdk.kotlin.services.applicationcostprofiler.ApplicationCostProfilerClient
import aws.sdk.kotlin.services.applicationcostprofiler.model.ListReportDefinitionsRequest
import aws.sdk.kotlin.services.applicationcostprofiler.model.ListReportDefinitionsResponse
import aws.sdk.kotlin.services.applicationcostprofiler.model.ReportDefinition
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListReportDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportDefinitionsResponse]
 */
public fun ApplicationCostProfilerClient.listReportDefinitionsPaginated(initialRequest: ListReportDefinitionsRequest = ListReportDefinitionsRequest { }): Flow<ListReportDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportDefinitionsPaginated.listReportDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReportDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportDefinitionsResponse]
 */
public fun ApplicationCostProfilerClient.listReportDefinitionsPaginated(block: ListReportDefinitionsRequest.Builder.() -> Unit): Flow<ListReportDefinitionsResponse> =
    listReportDefinitionsPaginated(ListReportDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReportDefinitionsPaginated]
 * to access the nested member [ReportDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReportDefinition]
 */
@JvmName("listReportDefinitionsResponseReportDefinition")
public fun Flow<ListReportDefinitionsResponse>.reportDefinitions(): Flow<ReportDefinition> =
    transform() { response ->
        response.reportDefinitions?.forEach {
            emit(it)
        }
    }
