// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the Amazon Simple Storage Service (Amazon S3) location where AWS Application Cost Profiler reports are generated and then written to.
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * Name of the S3 bucket.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Prefix for the location to write to.
     */
    public val prefix: kotlin.String = requireNotNull(builder.prefix) { "A non-null value must be provided for prefix" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (prefix.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the S3 bucket.
         */
        public var bucket: kotlin.String? = null
        /**
         * Prefix for the location to write to.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location) : this() {
            this.bucket = x.bucket
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location = S3Location(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (prefix == null) prefix = ""
            return this
        }
    }
}
