// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationcostprofiler.model.ApplicationCostProfilerException
import aws.sdk.kotlin.services.applicationcostprofiler.model.DeleteReportDefinitionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteReportDefinitionOperationDeserializer: HttpDeserialize<DeleteReportDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteReportDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwDeleteReportDefinitionError(context, response)
        }
        val builder = DeleteReportDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteReportDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteReportDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationCostProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationCostProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteReportDefinitionOperationBody(builder: DeleteReportDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPORTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPORTID_DESCRIPTOR.index -> builder.reportId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
