// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.DataIntegrationSummary
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListDataIntegrationsOperationDeserializer: HttpDeserialize<ListDataIntegrationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDataIntegrationsResponse {
        if (!response.status.isSuccess()) {
            throwListDataIntegrationsError(context, response)
        }
        val builder = ListDataIntegrationsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDataIntegrationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListDataIntegrationsOperationBody(builder: ListDataIntegrationsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATAINTEGRATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataIntegrations"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAINTEGRATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAINTEGRATIONS_DESCRIPTOR.index -> builder.dataIntegrations =
                    deserializer.deserializeList(DATAINTEGRATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataIntegrationSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataIntegrationSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListDataIntegrationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServiceError" -> InternalServiceErrorDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw AppIntegrationsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
