// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDataIntegrationOperationDeserializer: HttpDeserialize<CreateDataIntegrationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDataIntegrationResponse {
        if (!response.status.isSuccess()) {
            throwCreateDataIntegrationError(context, response)
        }
        val builder = CreateDataIntegrationResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDataIntegrationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateDataIntegrationOperationBody(builder: CreateDataIntegrationResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val SOURCEURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceURI"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(SOURCEURI_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CLIENTTOKEN_DESCRIPTOR.index -> builder.clientToken = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                KMSKEY_DESCRIPTOR.index -> builder.kmsKey = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SCHEDULECONFIGURATION_DESCRIPTOR.index -> builder.scheduleConfiguration = deserializeScheduleConfigurationDocument(deserializer)
                SOURCEURI_DESCRIPTOR.index -> builder.sourceUri = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateDataIntegrationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer()
        "InternalServiceError" -> InternalServiceErrorDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceQuotaExceededException" -> ResourceQuotaExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw AppIntegrationsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
