// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model



/**
 * The event integration association.
 */
class EventIntegrationAssociation private constructor(builder: BuilderImpl) {
    /**
     * The metadata associated with the client.
     */
    val clientAssociationMetadata: Map<String, String>? = builder.clientAssociationMetadata
    /**
     * The identifier for the client that is associated with the event integration.
     */
    val clientId: String? = builder.clientId
    /**
     * The name of the EventBridge rule.
     */
    val eventBridgeRuleName: String? = builder.eventBridgeRuleName
    /**
     * The Amazon Resource Name (ARN) for the event integration association.
     */
    val eventIntegrationAssociationArn: String? = builder.eventIntegrationAssociationArn
    /**
     * The identifier for the event integration association.
     */
    val eventIntegrationAssociationId: String? = builder.eventIntegrationAssociationId
    /**
     * The name of the event integration.
     */
    val eventIntegrationName: String? = builder.eventIntegrationName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventIntegrationAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventIntegrationAssociation(")
        append("clientAssociationMetadata=$clientAssociationMetadata,")
        append("clientId=$clientId,")
        append("eventBridgeRuleName=$eventBridgeRuleName,")
        append("eventIntegrationAssociationArn=$eventIntegrationAssociationArn,")
        append("eventIntegrationAssociationId=$eventIntegrationAssociationId,")
        append("eventIntegrationName=$eventIntegrationName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientAssociationMetadata?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (eventBridgeRuleName?.hashCode() ?: 0)
        result = 31 * result + (eventIntegrationAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (eventIntegrationAssociationId?.hashCode() ?: 0)
        result = 31 * result + (eventIntegrationName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventIntegrationAssociation

        if (clientAssociationMetadata != other.clientAssociationMetadata) return false
        if (clientId != other.clientId) return false
        if (eventBridgeRuleName != other.eventBridgeRuleName) return false
        if (eventIntegrationAssociationArn != other.eventIntegrationAssociationArn) return false
        if (eventIntegrationAssociationId != other.eventIntegrationAssociationId) return false
        if (eventIntegrationName != other.eventIntegrationName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventIntegrationAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventIntegrationAssociation
        /**
         * The metadata associated with the client.
         */
        fun clientAssociationMetadata(clientAssociationMetadata: Map<String, String>): FluentBuilder
        /**
         * The identifier for the client that is associated with the event integration.
         */
        fun clientId(clientId: String): FluentBuilder
        /**
         * The name of the EventBridge rule.
         */
        fun eventBridgeRuleName(eventBridgeRuleName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the event integration association.
         */
        fun eventIntegrationAssociationArn(eventIntegrationAssociationArn: String): FluentBuilder
        /**
         * The identifier for the event integration association.
         */
        fun eventIntegrationAssociationId(eventIntegrationAssociationId: String): FluentBuilder
        /**
         * The name of the event integration.
         */
        fun eventIntegrationName(eventIntegrationName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The metadata associated with the client.
         */
        var clientAssociationMetadata: Map<String, String>?
        /**
         * The identifier for the client that is associated with the event integration.
         */
        var clientId: String?
        /**
         * The name of the EventBridge rule.
         */
        var eventBridgeRuleName: String?
        /**
         * The Amazon Resource Name (ARN) for the event integration association.
         */
        var eventIntegrationAssociationArn: String?
        /**
         * The identifier for the event integration association.
         */
        var eventIntegrationAssociationId: String?
        /**
         * The name of the event integration.
         */
        var eventIntegrationName: String?

        fun build(): EventIntegrationAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientAssociationMetadata: Map<String, String>? = null
        override var clientId: String? = null
        override var eventBridgeRuleName: String? = null
        override var eventIntegrationAssociationArn: String? = null
        override var eventIntegrationAssociationId: String? = null
        override var eventIntegrationName: String? = null

        constructor(x: EventIntegrationAssociation) : this() {
            this.clientAssociationMetadata = x.clientAssociationMetadata
            this.clientId = x.clientId
            this.eventBridgeRuleName = x.eventBridgeRuleName
            this.eventIntegrationAssociationArn = x.eventIntegrationAssociationArn
            this.eventIntegrationAssociationId = x.eventIntegrationAssociationId
            this.eventIntegrationName = x.eventIntegrationName
        }

        override fun build(): EventIntegrationAssociation = EventIntegrationAssociation(this)
        override fun clientAssociationMetadata(clientAssociationMetadata: Map<String, String>): FluentBuilder = apply { this.clientAssociationMetadata = clientAssociationMetadata }
        override fun clientId(clientId: String): FluentBuilder = apply { this.clientId = clientId }
        override fun eventBridgeRuleName(eventBridgeRuleName: String): FluentBuilder = apply { this.eventBridgeRuleName = eventBridgeRuleName }
        override fun eventIntegrationAssociationArn(eventIntegrationAssociationArn: String): FluentBuilder = apply { this.eventIntegrationAssociationArn = eventIntegrationAssociationArn }
        override fun eventIntegrationAssociationId(eventIntegrationAssociationId: String): FluentBuilder = apply { this.eventIntegrationAssociationId = eventIntegrationAssociationId }
        override fun eventIntegrationName(eventIntegrationName: String): FluentBuilder = apply { this.eventIntegrationName = eventIntegrationName }
    }
}
