// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model



class CreateDataIntegrationRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A description of the DataIntegration.
     */
    val description: String? = builder.description
    /**
     * The KMS key for the DataIntegration.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The name of the DataIntegration.
     */
    val name: String? = builder.name
    /**
     * The name of the data and how often it should be pulled from the source.
     */
    val scheduleConfig: ScheduleConfiguration? = builder.scheduleConfig
    /**
     * The URI of the data source.
     */
    val sourceUri: String? = builder.sourceUri
    /**
     * One or more tags.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDataIntegrationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataIntegrationRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("kmsKey=$kmsKey,")
        append("name=$name,")
        append("scheduleConfig=$scheduleConfig,")
        append("sourceUri=$sourceUri,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scheduleConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceUri?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDataIntegrationRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (kmsKey != other.kmsKey) return false
        if (name != other.name) return false
        if (scheduleConfig != other.scheduleConfig) return false
        if (sourceUri != other.sourceUri) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDataIntegrationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDataIntegrationRequest
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A description of the DataIntegration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The KMS key for the DataIntegration.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The name of the DataIntegration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The name of the data and how often it should be pulled from the source.
         */
        fun scheduleConfig(scheduleConfig: ScheduleConfiguration): FluentBuilder
        /**
         * The URI of the data source.
         */
        fun sourceUri(sourceUri: String): FluentBuilder
        /**
         * One or more tags.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request.
         */
        var clientToken: String?
        /**
         * A description of the DataIntegration.
         */
        var description: String?
        /**
         * The KMS key for the DataIntegration.
         */
        var kmsKey: String?
        /**
         * The name of the DataIntegration.
         */
        var name: String?
        /**
         * The name of the data and how often it should be pulled from the source.
         */
        var scheduleConfig: ScheduleConfiguration?
        /**
         * The URI of the data source.
         */
        var sourceUri: String?
        /**
         * One or more tags.
         */
        var tags: Map<String, String>?

        fun build(): CreateDataIntegrationRequest
        /**
         * construct an [aws.sdk.kotlin.services.appintegrations.model.ScheduleConfiguration] inside the given [block]
         */
        fun scheduleConfig(block: ScheduleConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.scheduleConfig = ScheduleConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var kmsKey: String? = null
        override var name: String? = null
        override var scheduleConfig: ScheduleConfiguration? = null
        override var sourceUri: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateDataIntegrationRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.kmsKey = x.kmsKey
            this.name = x.name
            this.scheduleConfig = x.scheduleConfig
            this.sourceUri = x.sourceUri
            this.tags = x.tags
        }

        override fun build(): CreateDataIntegrationRequest = CreateDataIntegrationRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun scheduleConfig(scheduleConfig: ScheduleConfiguration): FluentBuilder = apply { this.scheduleConfig = scheduleConfig }
        override fun sourceUri(sourceUri: String): FluentBuilder = apply { this.sourceUri = sourceUri }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
