// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.appintegrations.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.appintegrations.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external
 * applications.
 * For information about how you can use external applications with Amazon Connect, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/crm.html">Set up pre-built
 * integrations and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-wisdom.html">Deliver information to agents using Amazon Connect Wisdom
 * in the Amazon Connect Administrator Guide.
 */
interface AppIntegrationsClient : SdkClient {

    override val serviceName: String
        get() = "AppIntegrations"
    /**
     * AppIntegrationsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): AppIntegrationsClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultAppIntegrationsClient(config)
        }

        operator fun invoke(config: Config): AppIntegrationsClient = DefaultAppIntegrationsClient(config)

        /**
         * Construct a [AppIntegrationsClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): AppIntegrationsClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return AppIntegrationsClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Creates and persists a DataIntegration resource.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * CreateDataIntegration API.
     */
    suspend fun createDataIntegration(input: CreateDataIntegrationRequest): CreateDataIntegrationResponse

    /**
     * Creates and persists a DataIntegration resource.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * CreateDataIntegration API.
     */
    suspend fun createDataIntegration(block: CreateDataIntegrationRequest.DslBuilder.() -> Unit) = createDataIntegration(CreateDataIntegrationRequest.builder().apply(block).build())

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an
     * Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No
     * objects are created in the your account, only metadata that is persisted on the
     * EventIntegration control plane.
     */
    suspend fun createEventIntegration(input: CreateEventIntegrationRequest): CreateEventIntegrationResponse

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an
     * Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No
     * objects are created in the your account, only metadata that is persisted on the
     * EventIntegration control plane.
     */
    suspend fun createEventIntegration(block: CreateEventIntegrationRequest.DslBuilder.() -> Unit) = createEventIntegration(CreateEventIntegrationRequest.builder().apply(block).build())

    /**
     * Deletes the DataIntegration. Only DataIntegrations that don't have any
     * DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the
     * underlying Amazon AppFlow flow and service linked role.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun deleteDataIntegration(input: DeleteDataIntegrationRequest): DeleteDataIntegrationResponse

    /**
     * Deletes the DataIntegration. Only DataIntegrations that don't have any
     * DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the
     * underlying Amazon AppFlow flow and service linked role.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun deleteDataIntegration(block: DeleteDataIntegrationRequest.DslBuilder.() -> Unit) = deleteDataIntegration(DeleteDataIntegrationRequest.builder().apply(block).build())

    /**
     * Deletes the specified existing event integration. If the event integration is associated
     * with clients, the request is rejected.
     */
    suspend fun deleteEventIntegration(input: DeleteEventIntegrationRequest): DeleteEventIntegrationResponse

    /**
     * Deletes the specified existing event integration. If the event integration is associated
     * with clients, the request is rejected.
     */
    suspend fun deleteEventIntegration(block: DeleteEventIntegrationRequest.DslBuilder.() -> Unit) = deleteEventIntegration(DeleteEventIntegrationRequest.builder().apply(block).build())

    /**
     * Returns information about the DataIntegration.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun getDataIntegration(input: GetDataIntegrationRequest): GetDataIntegrationResponse

    /**
     * Returns information about the DataIntegration.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun getDataIntegration(block: GetDataIntegrationRequest.DslBuilder.() -> Unit) = getDataIntegration(GetDataIntegrationRequest.builder().apply(block).build())

    /**
     * Returns information about the event integration.
     */
    suspend fun getEventIntegration(input: GetEventIntegrationRequest): GetEventIntegrationResponse

    /**
     * Returns information about the event integration.
     */
    suspend fun getEventIntegration(block: GetEventIntegrationRequest.DslBuilder.() -> Unit) = getEventIntegration(GetEventIntegrationRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of DataIntegration associations in the account.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun listDataIntegrationAssociations(input: ListDataIntegrationAssociationsRequest): ListDataIntegrationAssociationsResponse

    /**
     * Returns a paginated list of DataIntegration associations in the account.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun listDataIntegrationAssociations(block: ListDataIntegrationAssociationsRequest.DslBuilder.() -> Unit) = listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of DataIntegrations in the account.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun listDataIntegrations(input: ListDataIntegrationsRequest): ListDataIntegrationsResponse

    /**
     * Returns a paginated list of DataIntegrations in the account.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun listDataIntegrations(block: ListDataIntegrationsRequest.DslBuilder.() -> Unit) = listDataIntegrations(ListDataIntegrationsRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    suspend fun listEventIntegrationAssociations(input: ListEventIntegrationAssociationsRequest): ListEventIntegrationAssociationsResponse

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    suspend fun listEventIntegrationAssociations(block: ListEventIntegrationAssociationsRequest.DslBuilder.() -> Unit) = listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.builder().apply(block).build())

    /**
     * Returns a paginated list of event integrations in the account.
     */
    suspend fun listEventIntegrations(input: ListEventIntegrationsRequest): ListEventIntegrationsResponse

    /**
     * Returns a paginated list of event integrations in the account.
     */
    suspend fun listEventIntegrations(block: ListEventIntegrationsRequest.DslBuilder.() -> Unit) = listEventIntegrations(ListEventIntegrationsRequest.builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the description of a DataIntegration.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun updateDataIntegration(input: UpdateDataIntegrationRequest): UpdateDataIntegrationResponse

    /**
     * Updates the description of a DataIntegration.
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated.
     * Use a different DataIntegration, or recreate the DataIntegration using the
     * <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration API.
     */
    suspend fun updateDataIntegration(block: UpdateDataIntegrationRequest.DslBuilder.() -> Unit) = updateDataIntegration(UpdateDataIntegrationRequest.builder().apply(block).build())

    /**
     * Updates the description of an event integration.
     */
    suspend fun updateEventIntegration(input: UpdateEventIntegrationRequest): UpdateEventIntegrationResponse

    /**
     * Updates the description of an event integration.
     */
    suspend fun updateEventIntegration(block: UpdateEventIntegrationRequest.DslBuilder.() -> Unit) = updateEventIntegration(UpdateEventIntegrationRequest.builder().apply(block).build())
}
