// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.transform

import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.DataIntegrationAssociationSummary
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListDataIntegrationAssociationsOperationDeserializer: HttpDeserialize<ListDataIntegrationAssociationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDataIntegrationAssociationsResponse {
        if (!response.status.isSuccess()) {
            throwListDataIntegrationAssociationsError(context, response)
        }
        val builder = ListDataIntegrationAssociationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDataIntegrationAssociationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDataIntegrationAssociationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppIntegrationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppIntegrationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDataIntegrationAssociationsOperationBody(builder: ListDataIntegrationAssociationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATAINTEGRATIONASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataIntegrationAssociations"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAINTEGRATIONASSOCIATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAINTEGRATIONASSOCIATIONS_DESCRIPTOR.index -> builder.dataIntegrationAssociations =
                    deserializer.deserializeList(DATAINTEGRATIONASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataIntegrationAssociationSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataIntegrationAssociationSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
