// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.endpoints

import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test43() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://app-integrations.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test44() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test45() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test46() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
