// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.appintegrations.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.appintegrations.model.*
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.CreateEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.CreateEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.DeleteDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.DeleteDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.DeleteEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.DeleteEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.GetDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.GetDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.GetEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.GetEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.TagResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.TagResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.UntagResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.UntagResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.UpdateDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.UpdateDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.UpdateEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.UpdateEventIntegrationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 *
 * For information about how you can use external applications with Amazon Connect, see [Set up pre-built integrations](https://docs.aws.amazon.com/connect/latest/adminguide/crm.html) and [Deliver information to agents using Amazon Connect Wisdom](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-wisdom.html) in the *Amazon Connect Administrator Guide*.
 */
public interface AppIntegrationsClient : SdkClient {

    override val serviceName: String
        get() = "AppIntegrations"
    /**
     * AppIntegrationsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AppIntegrationsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAppIntegrationsClient(config)
        }

        public operator fun invoke(config: Config): AppIntegrationsClient = DefaultAppIntegrationsClient(config)

        /**
         * Construct a [AppIntegrationsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AppIntegrationsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAppIntegrationsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates and persists a DataIntegration resource.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the `CreateDataIntegration` API.
     */
    public suspend fun createDataIntegration(input: CreateDataIntegrationRequest): CreateDataIntegrationResponse

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.
     */
    public suspend fun createEventIntegration(input: CreateEventIntegrationRequest): CreateEventIntegrationResponse

    /**
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun deleteDataIntegration(input: DeleteDataIntegrationRequest): DeleteDataIntegrationResponse

    /**
     * Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.
     */
    public suspend fun deleteEventIntegration(input: DeleteEventIntegrationRequest): DeleteEventIntegrationResponse

    /**
     * Returns information about the DataIntegration.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun getDataIntegration(input: GetDataIntegrationRequest): GetDataIntegrationResponse

    /**
     * Returns information about the event integration.
     */
    public suspend fun getEventIntegration(input: GetEventIntegrationRequest): GetEventIntegrationResponse

    /**
     * Returns a paginated list of DataIntegration associations in the account.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun listDataIntegrationAssociations(input: ListDataIntegrationAssociationsRequest): ListDataIntegrationAssociationsResponse

    /**
     * Returns a paginated list of DataIntegrations in the account.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun listDataIntegrations(input: ListDataIntegrationsRequest = ListDataIntegrationsRequest {}): ListDataIntegrationsResponse

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    public suspend fun listEventIntegrationAssociations(input: ListEventIntegrationAssociationsRequest): ListEventIntegrationAssociationsResponse

    /**
     * Returns a paginated list of event integrations in the account.
     */
    public suspend fun listEventIntegrations(input: ListEventIntegrationsRequest = ListEventIntegrationsRequest {}): ListEventIntegrationsResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the description of a DataIntegration.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun updateDataIntegration(input: UpdateDataIntegrationRequest): UpdateDataIntegrationResponse

    /**
     * Updates the description of an event integration.
     */
    public suspend fun updateEventIntegration(input: UpdateEventIntegrationRequest): UpdateEventIntegrationResponse
}

/**
 * Creates and persists a DataIntegration resource.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the `CreateDataIntegration` API.
 */
public suspend inline fun AppIntegrationsClient.createDataIntegration(crossinline block: CreateDataIntegrationRequest.Builder.() -> Unit): CreateDataIntegrationResponse = createDataIntegration(CreateDataIntegrationRequest.Builder().apply(block).build())

/**
 * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.
 */
public suspend inline fun AppIntegrationsClient.createEventIntegration(crossinline block: CreateEventIntegrationRequest.Builder.() -> Unit): CreateEventIntegrationResponse = createEventIntegration(CreateEventIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.deleteDataIntegration(crossinline block: DeleteDataIntegrationRequest.Builder.() -> Unit): DeleteDataIntegrationResponse = deleteDataIntegration(DeleteDataIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.
 */
public suspend inline fun AppIntegrationsClient.deleteEventIntegration(crossinline block: DeleteEventIntegrationRequest.Builder.() -> Unit): DeleteEventIntegrationResponse = deleteEventIntegration(DeleteEventIntegrationRequest.Builder().apply(block).build())

/**
 * Returns information about the DataIntegration.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.getDataIntegration(crossinline block: GetDataIntegrationRequest.Builder.() -> Unit): GetDataIntegrationResponse = getDataIntegration(GetDataIntegrationRequest.Builder().apply(block).build())

/**
 * Returns information about the event integration.
 */
public suspend inline fun AppIntegrationsClient.getEventIntegration(crossinline block: GetEventIntegrationRequest.Builder.() -> Unit): GetEventIntegrationResponse = getEventIntegration(GetEventIntegrationRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of DataIntegration associations in the account.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.listDataIntegrationAssociations(crossinline block: ListDataIntegrationAssociationsRequest.Builder.() -> Unit): ListDataIntegrationAssociationsResponse = listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of DataIntegrations in the account.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.listDataIntegrations(crossinline block: ListDataIntegrationsRequest.Builder.() -> Unit): ListDataIntegrationsResponse = listDataIntegrations(ListDataIntegrationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of event integration associations in the account.
 */
public suspend inline fun AppIntegrationsClient.listEventIntegrationAssociations(crossinline block: ListEventIntegrationAssociationsRequest.Builder.() -> Unit): ListEventIntegrationAssociationsResponse = listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of event integrations in the account.
 */
public suspend inline fun AppIntegrationsClient.listEventIntegrations(crossinline block: ListEventIntegrationsRequest.Builder.() -> Unit): ListEventIntegrationsResponse = listEventIntegrations(ListEventIntegrationsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun AppIntegrationsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 */
public suspend inline fun AppIntegrationsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun AppIntegrationsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the description of a DataIntegration.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.updateDataIntegration(crossinline block: UpdateDataIntegrationRequest.Builder.() -> Unit): UpdateDataIntegrationResponse = updateDataIntegration(UpdateDataIntegrationRequest.Builder().apply(block).build())

/**
 * Updates the description of an event integration.
 */
public suspend inline fun AppIntegrationsClient.updateEventIntegration(crossinline block: UpdateEventIntegrationRequest.Builder.() -> Unit): UpdateEventIntegrationResponse = updateEventIntegration(UpdateEventIntegrationRequest.Builder().apply(block).build())
