// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.serde

import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationRequest
import aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDataIntegrationAssociationOperationSerializer: HttpSerializer.NonStreaming<CreateDataIntegrationAssociationRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDataIntegrationAssociationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.dataIntegrationIdentifier) { "dataIntegrationIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("dataIntegrations"))
                add(PercentEncoding.SmithyLabel.encode(input.dataIntegrationIdentifier))
                add(PercentEncoding.Path.encode("associations"))
            }
        }

        val payload = serializeCreateDataIntegrationAssociationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataIntegrationAssociationOperationBody(context: ExecutionContext, input: CreateDataIntegrationAssociationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTASSOCIATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ClientAssociationMetadata"))
    val CLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientId"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESTINATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DestinationURI"))
    val EXECUTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExecutionConfiguration"))
    val OBJECTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ObjectConfiguration"))
    val OBJECTCONFIGURATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJECTCONFIGURATION_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTASSOCIATIONMETADATA_DESCRIPTOR)
        field(CLIENTID_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESTINATIONURI_DESCRIPTOR)
        field(EXECUTIONCONFIGURATION_DESCRIPTOR)
        field(OBJECTCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.clientAssociationMetadata != null) {
            mapField(CLIENTASSOCIATIONMETADATA_DESCRIPTOR) {
                input.clientAssociationMetadata.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.clientId?.let { field(CLIENTID_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.destinationUri?.let { field(DESTINATIONURI_DESCRIPTOR, it) }
        input.executionConfiguration?.let { field(EXECUTIONCONFIGURATION_DESCRIPTOR, it, ::serializeExecutionConfigurationDocument) }
        if (input.objectConfiguration != null) {
            mapField(OBJECTCONFIGURATION_DESCRIPTOR) {
                input.objectConfiguration.forEach { (key, value) ->
                    mapEntry(key, OBJECTCONFIGURATION_C0_DESCRIPTOR) {
                        value.forEach { (key1, value1) ->
                            listEntry(key1, OBJECTCONFIGURATION_C1_DESCRIPTOR) {
                                for (el2 in value1) {
                                    serializeString(el2)
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return serializer.toByteArray()
}
