// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.serde

import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDataIntegrationAssociationOperationDeserializer: HttpDeserializer.NonStreaming<CreateDataIntegrationAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDataIntegrationAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDataIntegrationAssociationError(context, call, payload)
        }
        val builder = CreateDataIntegrationAssociationResponse.Builder()

        if (payload != null) {
            deserializeCreateDataIntegrationAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDataIntegrationAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppIntegrationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceQuotaExceededException" -> ResourceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppIntegrationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDataIntegrationAssociationOperationBody(builder: CreateDataIntegrationAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATAINTEGRATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataIntegrationArn"))
    val DATAINTEGRATIONASSOCIATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataIntegrationAssociationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAINTEGRATIONARN_DESCRIPTOR)
        field(DATAINTEGRATIONASSOCIATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAINTEGRATIONARN_DESCRIPTOR.index -> builder.dataIntegrationArn = deserializeString()
                DATAINTEGRATIONASSOCIATIONID_DESCRIPTOR.index -> builder.dataIntegrationAssociationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
