// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateApplicationRequest private constructor(builder: Builder) {
    /**
     * The configuration for where the application should be loaded from.
     */
    public val applicationSourceConfig: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig? = builder.applicationSourceConfig
    /**
     * The Amazon Resource Name (ARN) of the Application.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration of events or requests that the application has access to.
     */
    public val permissions: List<String>? = builder.permissions
    /**
     * The events that the application publishes.
     */
    @Deprecated("Publications has been replaced with Permissions")
    public val publications: List<Publication>? = builder.publications
    /**
     * The events that the application subscribes.
     */
    @Deprecated("Subscriptions has been replaced with Permissions")
    public val subscriptions: List<Subscription>? = builder.subscriptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApplicationRequest(")
        append("applicationSourceConfig=$applicationSourceConfig,")
        append("arn=$arn,")
        append("description=$description,")
        append("name=$name,")
        append("permissions=$permissions,")
        append("publications=$publications,")
        append("subscriptions=$subscriptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSourceConfig?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (publications?.hashCode() ?: 0)
        result = 31 * result + (subscriptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApplicationRequest

        if (applicationSourceConfig != other.applicationSourceConfig) return false
        if (arn != other.arn) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (permissions != other.permissions) return false
        if (publications != other.publications) return false
        if (subscriptions != other.subscriptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for where the application should be loaded from.
         */
        public var applicationSourceConfig: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the Application.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration of events or requests that the application has access to.
         */
        public var permissions: List<String>? = null
        /**
         * The events that the application publishes.
         */
        @Deprecated("Publications has been replaced with Permissions")
        public var publications: List<Publication>? = null
        /**
         * The events that the application subscribes.
         */
        @Deprecated("Subscriptions has been replaced with Permissions")
        public var subscriptions: List<Subscription>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest) : this() {
            this.applicationSourceConfig = x.applicationSourceConfig
            this.arn = x.arn
            this.description = x.description
            this.name = x.name
            this.permissions = x.permissions
            this.publications = x.publications
            this.subscriptions = x.subscriptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest = UpdateApplicationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig] inside the given [block]
         */
        public fun applicationSourceConfig(block: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig.Builder.() -> kotlin.Unit) {
            this.applicationSourceConfig = aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
