// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetApplicationResponse private constructor(builder: Builder) {
    /**
     * The configuration for where the application should be loaded from.
     */
    public val applicationSourceConfig: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig? = builder.applicationSourceConfig
    /**
     * The Amazon Resource Name (ARN) of the Application.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The created time of the Application.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the Application.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The last modified time of the Application.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The namespace of the application.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The configuration of events or requests that the application has access to.
     */
    public val permissions: List<String>? = builder.permissions
    /**
     * The events that the application publishes.
     */
    @Deprecated("Publications has been replaced with Permissions")
    public val publications: List<Publication>? = builder.publications
    /**
     * The events that the application subscribes.
     */
    @Deprecated("Subscriptions has been replaced with Permissions")
    public val subscriptions: List<Subscription>? = builder.subscriptions
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appintegrations.model.GetApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetApplicationResponse(")
        append("applicationSourceConfig=$applicationSourceConfig,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("namespace=$namespace,")
        append("permissions=$permissions,")
        append("publications=$publications,")
        append("subscriptions=$subscriptions,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSourceConfig?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (publications?.hashCode() ?: 0)
        result = 31 * result + (subscriptions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetApplicationResponse

        if (applicationSourceConfig != other.applicationSourceConfig) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (namespace != other.namespace) return false
        if (permissions != other.permissions) return false
        if (publications != other.publications) return false
        if (subscriptions != other.subscriptions) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appintegrations.model.GetApplicationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for where the application should be loaded from.
         */
        public var applicationSourceConfig: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the Application.
         */
        public var arn: kotlin.String? = null
        /**
         * The created time of the Application.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the Application.
         */
        public var id: kotlin.String? = null
        /**
         * The last modified time of the Application.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The namespace of the application.
         */
        public var namespace: kotlin.String? = null
        /**
         * The configuration of events or requests that the application has access to.
         */
        public var permissions: List<String>? = null
        /**
         * The events that the application publishes.
         */
        @Deprecated("Publications has been replaced with Permissions")
        public var publications: List<Publication>? = null
        /**
         * The events that the application subscribes.
         */
        @Deprecated("Subscriptions has been replaced with Permissions")
        public var subscriptions: List<Subscription>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appintegrations.model.GetApplicationResponse) : this() {
            this.applicationSourceConfig = x.applicationSourceConfig
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.namespace = x.namespace
            this.permissions = x.permissions
            this.publications = x.publications
            this.subscriptions = x.subscriptions
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appintegrations.model.GetApplicationResponse = GetApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig] inside the given [block]
         */
        public fun applicationSourceConfig(block: aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig.Builder.() -> kotlin.Unit) {
            this.applicationSourceConfig = aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
