// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDataIntegrationAssociationRequest private constructor(builder: Builder) {
    /**
     * The mapping of metadata to be extracted from the data.
     */
    public val clientAssociationMetadata: Map<String, String>? = builder.clientAssociationMetadata
    /**
     * The identifier for the client that is associated with the DataIntegration association.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A unique identifier for the DataIntegration.
     */
    public val dataIntegrationIdentifier: kotlin.String? = builder.dataIntegrationIdentifier
    /**
     * The URI of the data destination.
     */
    public val destinationUri: kotlin.String? = builder.destinationUri
    /**
     * The configuration for how the files should be pulled from the source.
     */
    public val executionConfiguration: aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration? = builder.executionConfiguration
    /**
     * The configuration for what data should be pulled from the source.
     */
    public val objectConfiguration: Map<String, Map<String, List<String>>>? = builder.objectConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataIntegrationAssociationRequest(")
        append("clientAssociationMetadata=$clientAssociationMetadata,")
        append("clientId=$clientId,")
        append("clientToken=$clientToken,")
        append("dataIntegrationIdentifier=$dataIntegrationIdentifier,")
        append("destinationUri=$destinationUri,")
        append("executionConfiguration=$executionConfiguration,")
        append("objectConfiguration=$objectConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientAssociationMetadata?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dataIntegrationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (destinationUri?.hashCode() ?: 0)
        result = 31 * result + (executionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (objectConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataIntegrationAssociationRequest

        if (clientAssociationMetadata != other.clientAssociationMetadata) return false
        if (clientId != other.clientId) return false
        if (clientToken != other.clientToken) return false
        if (dataIntegrationIdentifier != other.dataIntegrationIdentifier) return false
        if (destinationUri != other.destinationUri) return false
        if (executionConfiguration != other.executionConfiguration) return false
        if (objectConfiguration != other.objectConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The mapping of metadata to be extracted from the data.
         */
        public var clientAssociationMetadata: Map<String, String>? = null
        /**
         * The identifier for the client that is associated with the DataIntegration association.
         */
        public var clientId: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * A unique identifier for the DataIntegration.
         */
        public var dataIntegrationIdentifier: kotlin.String? = null
        /**
         * The URI of the data destination.
         */
        public var destinationUri: kotlin.String? = null
        /**
         * The configuration for how the files should be pulled from the source.
         */
        public var executionConfiguration: aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration? = null
        /**
         * The configuration for what data should be pulled from the source.
         */
        public var objectConfiguration: Map<String, Map<String, List<String>>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationRequest) : this() {
            this.clientAssociationMetadata = x.clientAssociationMetadata
            this.clientId = x.clientId
            this.clientToken = x.clientToken
            this.dataIntegrationIdentifier = x.dataIntegrationIdentifier
            this.destinationUri = x.destinationUri
            this.executionConfiguration = x.executionConfiguration
            this.objectConfiguration = x.objectConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationAssociationRequest = CreateDataIntegrationAssociationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration] inside the given [block]
         */
        public fun executionConfiguration(block: aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration.Builder.() -> kotlin.Unit) {
            this.executionConfiguration = aws.sdk.kotlin.services.appintegrations.model.ExecutionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
