// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.serde

import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.FileConfiguration
import aws.sdk.kotlin.services.appintegrations.model.ScheduleConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDataIntegrationOperationSerializer: HttpSerializer.NonStreaming<CreateDataIntegrationRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDataIntegrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/dataIntegrations"
        }

        val payload = serializeCreateDataIntegrationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataIntegrationOperationBody(context: ExecutionContext, input: CreateDataIntegrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FILECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FileConfiguration"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJECTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ObjectConfiguration"))
    val OBJECTCONFIGURATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJECTCONFIGURATION_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SCHEDULECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfig"))
    val SOURCEURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceURI"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FILECONFIGURATION_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OBJECTCONFIGURATION_DESCRIPTOR)
        field(SCHEDULECONFIG_DESCRIPTOR)
        field(SOURCEURI_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.fileConfiguration?.let { field(FILECONFIGURATION_DESCRIPTOR, it, ::serializeFileConfigurationDocument) }
        input.kmsKey?.let { field(KMSKEY_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.objectConfiguration != null) {
            mapField(OBJECTCONFIGURATION_DESCRIPTOR) {
                input.objectConfiguration.forEach { (key, value) ->
                    mapEntry(key, OBJECTCONFIGURATION_C0_DESCRIPTOR) {
                        value.forEach { (key1, value1) ->
                            listEntry(key1, OBJECTCONFIGURATION_C1_DESCRIPTOR) {
                                for (el2 in value1) {
                                    serializeString(el2)
                                }
                            }
                        }
                    }
                }
            }
        }
        input.scheduleConfig?.let { field(SCHEDULECONFIG_DESCRIPTOR, it, ::serializeScheduleConfigurationDocument) }
        input.sourceUri?.let { field(SOURCEURI_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
