// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.paginators

import aws.sdk.kotlin.services.appintegrations.AppIntegrationsClient
import aws.sdk.kotlin.services.appintegrations.model.ApplicationAssociationSummary
import aws.sdk.kotlin.services.appintegrations.model.ApplicationSummary
import aws.sdk.kotlin.services.appintegrations.model.DataIntegrationAssociationSummary
import aws.sdk.kotlin.services.appintegrations.model.DataIntegrationSummary
import aws.sdk.kotlin.services.appintegrations.model.EventIntegration
import aws.sdk.kotlin.services.appintegrations.model.EventIntegrationAssociation
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationAssociationsResponse]
 */
public fun AppIntegrationsClient.listApplicationAssociationsPaginated(initialRequest: ListApplicationAssociationsRequest): Flow<ListApplicationAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationAssociationsPaginated.listApplicationAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationAssociationsResponse]
 */
public fun AppIntegrationsClient.listApplicationAssociationsPaginated(block: ListApplicationAssociationsRequest.Builder.() -> Unit): Flow<ListApplicationAssociationsResponse> =
    listApplicationAssociationsPaginated(ListApplicationAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationAssociationsPaginated]
 * to access the nested member [ApplicationAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationAssociationSummary]
 */
@JvmName("listApplicationAssociationsResponseApplicationAssociationSummary")
public fun Flow<ListApplicationAssociationsResponse>.applicationAssociations(): Flow<ApplicationAssociationSummary> =
    transform() { response ->
        response.applicationAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun AppIntegrationsClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun AppIntegrationsClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applications(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataIntegrationAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataIntegrationAssociationsResponse]
 */
public fun AppIntegrationsClient.listDataIntegrationAssociationsPaginated(initialRequest: ListDataIntegrationAssociationsRequest): Flow<ListDataIntegrationAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataIntegrationAssociationsPaginated.listDataIntegrationAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataIntegrationAssociationsResponse]
 */
public fun AppIntegrationsClient.listDataIntegrationAssociationsPaginated(block: ListDataIntegrationAssociationsRequest.Builder.() -> Unit): Flow<ListDataIntegrationAssociationsResponse> =
    listDataIntegrationAssociationsPaginated(ListDataIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataIntegrationAssociationsPaginated]
 * to access the nested member [DataIntegrationAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataIntegrationAssociationSummary]
 */
@JvmName("listDataIntegrationAssociationsResponseDataIntegrationAssociationSummary")
public fun Flow<ListDataIntegrationAssociationsResponse>.dataIntegrationAssociations(): Flow<DataIntegrationAssociationSummary> =
    transform() { response ->
        response.dataIntegrationAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataIntegrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataIntegrationsResponse]
 */
public fun AppIntegrationsClient.listDataIntegrationsPaginated(initialRequest: ListDataIntegrationsRequest = ListDataIntegrationsRequest { }): Flow<ListDataIntegrationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataIntegrationsPaginated.listDataIntegrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataIntegrationsResponse]
 */
public fun AppIntegrationsClient.listDataIntegrationsPaginated(block: ListDataIntegrationsRequest.Builder.() -> Unit): Flow<ListDataIntegrationsResponse> =
    listDataIntegrationsPaginated(ListDataIntegrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataIntegrationsPaginated]
 * to access the nested member [DataIntegrationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataIntegrationSummary]
 */
@JvmName("listDataIntegrationsResponseDataIntegrationSummary")
public fun Flow<ListDataIntegrationsResponse>.dataIntegrations(): Flow<DataIntegrationSummary> =
    transform() { response ->
        response.dataIntegrations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventIntegrationAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventIntegrationAssociationsResponse]
 */
public fun AppIntegrationsClient.listEventIntegrationAssociationsPaginated(initialRequest: ListEventIntegrationAssociationsRequest): Flow<ListEventIntegrationAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventIntegrationAssociationsPaginated.listEventIntegrationAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventIntegrationAssociationsResponse]
 */
public fun AppIntegrationsClient.listEventIntegrationAssociationsPaginated(block: ListEventIntegrationAssociationsRequest.Builder.() -> Unit): Flow<ListEventIntegrationAssociationsResponse> =
    listEventIntegrationAssociationsPaginated(ListEventIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventIntegrationAssociationsPaginated]
 * to access the nested member [EventIntegrationAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventIntegrationAssociation]
 */
@JvmName("listEventIntegrationAssociationsResponseEventIntegrationAssociation")
public fun Flow<ListEventIntegrationAssociationsResponse>.eventIntegrationAssociations(): Flow<EventIntegrationAssociation> =
    transform() { response ->
        response.eventIntegrationAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventIntegrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventIntegrationsResponse]
 */
public fun AppIntegrationsClient.listEventIntegrationsPaginated(initialRequest: ListEventIntegrationsRequest = ListEventIntegrationsRequest { }): Flow<ListEventIntegrationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventIntegrationsPaginated.listEventIntegrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventIntegrationsResponse]
 */
public fun AppIntegrationsClient.listEventIntegrationsPaginated(block: ListEventIntegrationsRequest.Builder.() -> Unit): Flow<ListEventIntegrationsResponse> =
    listEventIntegrationsPaginated(ListEventIntegrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventIntegrationsPaginated]
 * to access the nested member [EventIntegration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventIntegration]
 */
@JvmName("listEventIntegrationsResponseEventIntegration")
public fun Flow<ListEventIntegrationsResponse>.eventIntegrations(): Flow<EventIntegration> =
    transform() { response ->
        response.eventIntegrations?.forEach {
            emit(it)
        }
    }
