// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.serde

import aws.sdk.kotlin.services.appintegrations.model.ApplicationSourceConfig
import aws.sdk.kotlin.services.appintegrations.model.Publication
import aws.sdk.kotlin.services.appintegrations.model.Subscription
import aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateApplicationOperationSerializer: HttpSerializer.NonStreaming<UpdateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.arn) { "arn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode("${input.arn}"))
            }
        }

        val payload = serializeUpdateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApplicationOperationBody(context: ExecutionContext, input: UpdateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPLICATIONSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApplicationSourceConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val PUBLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Publications"))
    val SUBSCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Subscriptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONSOURCECONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(PUBLICATIONS_DESCRIPTOR)
        field(SUBSCRIPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationSourceConfig?.let { field(APPLICATIONSOURCECONFIG_DESCRIPTOR, it, ::serializeApplicationSourceConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeString(el0)
                }
            }
        }
        if (input.publications != null) {
            listField(PUBLICATIONS_DESCRIPTOR) {
                for (el0 in input.publications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePublicationDocument))
                }
            }
        }
        if (input.subscriptions != null) {
            listField(SUBSCRIPTIONS_DESCRIPTOR) {
                for (el0 in input.subscriptions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSubscriptionDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
