// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.serde

import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.FileConfiguration
import aws.sdk.kotlin.services.appintegrations.model.ScheduleConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateDataIntegrationOperationDeserializer: HttpDeserializer.NonStreaming<CreateDataIntegrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDataIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDataIntegrationError(context, call, payload)
        }
        val builder = CreateDataIntegrationResponse.Builder()

        if (payload != null) {
            deserializeCreateDataIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDataIntegrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppIntegrationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceQuotaExceededException" -> ResourceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppIntegrationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDataIntegrationOperationBody(builder: CreateDataIntegrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FILECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FileConfiguration"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJECTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ObjectConfiguration"))
    val OBJECTCONFIGURATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJECTCONFIGURATION_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val SOURCEURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceURI"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FILECONFIGURATION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OBJECTCONFIGURATION_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(SOURCEURI_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CLIENTTOKEN_DESCRIPTOR.index -> builder.clientToken = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FILECONFIGURATION_DESCRIPTOR.index -> builder.fileConfiguration = deserializeFileConfigurationDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                KMSKEY_DESCRIPTOR.index -> builder.kmsKey = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OBJECTCONFIGURATION_DESCRIPTOR.index -> builder.objectConfiguration =
                    deserializer.deserializeMap(OBJECTCONFIGURATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Map<String, List<String>>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeMap(OBJECTCONFIGURATION_C0_DESCRIPTOR) {
                                        val map1 = mutableMapOf<String, List<String>>()
                                        while (hasNextEntry()) {
                                            val k1 = key()
                                            val v1 =
                                                if (nextHasValue()) {
                                                    deserializer.deserializeList(OBJECTCONFIGURATION_C1_DESCRIPTOR) {
                                                        val col2 = mutableListOf<String>()
                                                        while (hasNextElement()) {
                                                            val el2 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                                            col2.add(el2)
                                                        }
                                                        col2
                                                    }
                                                } else { deserializeNull(); continue }

                                            map1[k1] = v1
                                        }
                                        map1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                SCHEDULECONFIGURATION_DESCRIPTOR.index -> builder.scheduleConfiguration = deserializeScheduleConfigurationDocument(deserializer)
                SOURCEURI_DESCRIPTOR.index -> builder.sourceUri = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
