// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appintegrations.auth.AppIntegrationsAuthSchemeProvider
import aws.sdk.kotlin.services.appintegrations.auth.DefaultAppIntegrationsAuthSchemeProvider
import aws.sdk.kotlin.services.appintegrations.endpoints.AppIntegrationsEndpointParameters
import aws.sdk.kotlin.services.appintegrations.endpoints.AppIntegrationsEndpointProvider
import aws.sdk.kotlin.services.appintegrations.endpoints.DefaultAppIntegrationsEndpointProvider
import aws.sdk.kotlin.services.appintegrations.model.CreateApplicationRequest
import aws.sdk.kotlin.services.appintegrations.model.CreateApplicationResponse
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.CreateDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.CreateEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.CreateEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.appintegrations.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.appintegrations.model.DeleteDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.DeleteDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.DeleteEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.DeleteEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.GetApplicationRequest
import aws.sdk.kotlin.services.appintegrations.model.GetApplicationResponse
import aws.sdk.kotlin.services.appintegrations.model.GetDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.GetDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.GetEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.GetEventIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListApplicationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListDataIntegrationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsRequest
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationsResponse
import aws.sdk.kotlin.services.appintegrations.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.TagResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.TagResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.UntagResourceRequest
import aws.sdk.kotlin.services.appintegrations.model.UntagResourceResponse
import aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.appintegrations.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.appintegrations.model.UpdateDataIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.UpdateDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.UpdateEventIntegrationRequest
import aws.sdk.kotlin.services.appintegrations.model.UpdateEventIntegrationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppIntegrations"
public const val SdkVersion: String = "1.1.18"
public const val ServiceApiVersion: String = "2020-07-29"

/**
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 *
 * For information about how you can use external applications with Amazon Connect, see [Set up pre-built integrations](https://docs.aws.amazon.com/connect/latest/adminguide/crm.html) and [Deliver information to agents using Amazon Connect Wisdom](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-wisdom.html) in the *Amazon Connect Administrator Guide*.
 */
public interface AppIntegrationsClient : SdkClient {
    /**
     * AppIntegrationsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppIntegrationsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppIntegrations",
                "APPINTEGRATIONS",
                "appintegrations",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppIntegrationsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppIntegrationsClient = DefaultAppIntegrationsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppIntegrationsEndpointProvider = builder.endpointProvider ?: DefaultAppIntegrationsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppIntegrationsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppIntegrationsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppIntegrations"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppIntegrationsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppIntegrationsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This API is in preview release and subject to change.
     *
     * Creates and persists an Application resource.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.CreateApplication.sample
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates and persists a DataIntegration resource.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the `CreateDataIntegration` API.
     */
    public suspend fun createDataIntegration(input: CreateDataIntegrationRequest): CreateDataIntegrationResponse

    /**
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.
     */
    public suspend fun createEventIntegration(input: CreateEventIntegrationRequest): CreateEventIntegrationResponse

    /**
     * Deletes the Application. Only Applications that don't have any Application Associations can be deleted.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.DeleteApplication.sample
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun deleteDataIntegration(input: DeleteDataIntegrationRequest): DeleteDataIntegrationResponse

    /**
     * Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.
     */
    public suspend fun deleteEventIntegration(input: DeleteEventIntegrationRequest): DeleteEventIntegrationResponse

    /**
     * This API is in preview release and subject to change.
     *
     * Get an Application resource.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.GetApplication.sample
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Returns information about the DataIntegration.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun getDataIntegration(input: GetDataIntegrationRequest): GetDataIntegrationResponse

    /**
     * Returns information about the event integration.
     */
    public suspend fun getEventIntegration(input: GetEventIntegrationRequest): GetEventIntegrationResponse

    /**
     * Returns a paginated list of application associations for an application.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.ListApplicationAssociations.sample
     */
    public suspend fun listApplicationAssociations(input: ListApplicationAssociationsRequest): ListApplicationAssociationsResponse

    /**
     * This API is in preview release and subject to change.
     *
     * Lists applications in the account.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.ListApplications.sample
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Returns a paginated list of DataIntegration associations in the account.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun listDataIntegrationAssociations(input: ListDataIntegrationAssociationsRequest): ListDataIntegrationAssociationsResponse

    /**
     * Returns a paginated list of DataIntegrations in the account.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun listDataIntegrations(input: ListDataIntegrationsRequest = ListDataIntegrationsRequest { }): ListDataIntegrationsResponse

    /**
     * Returns a paginated list of event integration associations in the account.
     */
    public suspend fun listEventIntegrationAssociations(input: ListEventIntegrationAssociationsRequest): ListEventIntegrationAssociationsResponse

    /**
     * Returns a paginated list of event integrations in the account.
     */
    public suspend fun listEventIntegrations(input: ListEventIntegrationsRequest = ListEventIntegrationsRequest { }): ListEventIntegrationsResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This API is in preview release and subject to change.
     *
     * Updates and persists an Application resource.
     *
     * @sample aws.sdk.kotlin.services.appintegrations.samples.UpdateApplication.sample
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the description of a DataIntegration.
     *
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
     */
    public suspend fun updateDataIntegration(input: UpdateDataIntegrationRequest): UpdateDataIntegrationResponse

    /**
     * Updates the description of an event integration.
     */
    public suspend fun updateEventIntegration(input: UpdateEventIntegrationRequest): UpdateEventIntegrationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppIntegrationsClient.withConfig(block: AppIntegrationsClient.Config.Builder.() -> Unit): AppIntegrationsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppIntegrationsClient(newConfig)
}

/**
 * This API is in preview release and subject to change.
 *
 * Creates and persists an Application resource.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.CreateApplication.sample
 */
public suspend inline fun AppIntegrationsClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates and persists a DataIntegration resource.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the `CreateDataIntegration` API.
 */
public suspend inline fun AppIntegrationsClient.createDataIntegration(crossinline block: CreateDataIntegrationRequest.Builder.() -> Unit): CreateDataIntegrationResponse = createDataIntegration(CreateDataIntegrationRequest.Builder().apply(block).build())

/**
 * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.
 */
public suspend inline fun AppIntegrationsClient.createEventIntegration(crossinline block: CreateEventIntegrationRequest.Builder.() -> Unit): CreateEventIntegrationResponse = createEventIntegration(CreateEventIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes the Application. Only Applications that don't have any Application Associations can be deleted.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.DeleteApplication.sample
 */
public suspend inline fun AppIntegrationsClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.deleteDataIntegration(crossinline block: DeleteDataIntegrationRequest.Builder.() -> Unit): DeleteDataIntegrationResponse = deleteDataIntegration(DeleteDataIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.
 */
public suspend inline fun AppIntegrationsClient.deleteEventIntegration(crossinline block: DeleteEventIntegrationRequest.Builder.() -> Unit): DeleteEventIntegrationResponse = deleteEventIntegration(DeleteEventIntegrationRequest.Builder().apply(block).build())

/**
 * This API is in preview release and subject to change.
 *
 * Get an Application resource.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.GetApplication.sample
 */
public suspend inline fun AppIntegrationsClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Returns information about the DataIntegration.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.getDataIntegration(crossinline block: GetDataIntegrationRequest.Builder.() -> Unit): GetDataIntegrationResponse = getDataIntegration(GetDataIntegrationRequest.Builder().apply(block).build())

/**
 * Returns information about the event integration.
 */
public suspend inline fun AppIntegrationsClient.getEventIntegration(crossinline block: GetEventIntegrationRequest.Builder.() -> Unit): GetEventIntegrationResponse = getEventIntegration(GetEventIntegrationRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of application associations for an application.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.ListApplicationAssociations.sample
 */
public suspend inline fun AppIntegrationsClient.listApplicationAssociations(crossinline block: ListApplicationAssociationsRequest.Builder.() -> Unit): ListApplicationAssociationsResponse = listApplicationAssociations(ListApplicationAssociationsRequest.Builder().apply(block).build())

/**
 * This API is in preview release and subject to change.
 *
 * Lists applications in the account.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.ListApplications.sample
 */
public suspend inline fun AppIntegrationsClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of DataIntegration associations in the account.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.listDataIntegrationAssociations(crossinline block: ListDataIntegrationAssociationsRequest.Builder.() -> Unit): ListDataIntegrationAssociationsResponse = listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of DataIntegrations in the account.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.listDataIntegrations(crossinline block: ListDataIntegrationsRequest.Builder.() -> Unit): ListDataIntegrationsResponse = listDataIntegrations(ListDataIntegrationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of event integration associations in the account.
 */
public suspend inline fun AppIntegrationsClient.listEventIntegrationAssociations(crossinline block: ListEventIntegrationAssociationsRequest.Builder.() -> Unit): ListEventIntegrationAssociationsResponse = listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of event integrations in the account.
 */
public suspend inline fun AppIntegrationsClient.listEventIntegrations(crossinline block: ListEventIntegrationsRequest.Builder.() -> Unit): ListEventIntegrationsResponse = listEventIntegrations(ListEventIntegrationsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun AppIntegrationsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 */
public suspend inline fun AppIntegrationsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun AppIntegrationsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This API is in preview release and subject to change.
 *
 * Updates and persists an Application resource.
 *
 * @sample aws.sdk.kotlin.services.appintegrations.samples.UpdateApplication.sample
 */
public suspend inline fun AppIntegrationsClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the description of a DataIntegration.
 *
 * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a different DataIntegration, or recreate the DataIntegration using the [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) API.
 */
public suspend inline fun AppIntegrationsClient.updateDataIntegration(crossinline block: UpdateDataIntegrationRequest.Builder.() -> Unit): UpdateDataIntegrationResponse = updateDataIntegration(UpdateDataIntegrationRequest.Builder().apply(block).build())

/**
 * Updates the description of an event integration.
 */
public suspend inline fun AppIntegrationsClient.updateEventIntegration(crossinline block: UpdateEventIntegrationRequest.Builder.() -> Unit): UpdateEventIntegrationResponse = updateEventIntegration(UpdateEventIntegrationRequest.Builder().apply(block).build())
