// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.transform

import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.FileConfiguration
import aws.sdk.kotlin.services.appintegrations.model.GetDataIntegrationResponse
import aws.sdk.kotlin.services.appintegrations.model.ScheduleConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetDataIntegrationOperationDeserializer: HttpDeserialize<GetDataIntegrationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDataIntegrationResponse {
        if (!response.status.isSuccess()) {
            throwGetDataIntegrationError(context, response)
        }
        val builder = GetDataIntegrationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDataIntegrationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDataIntegrationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppIntegrationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppIntegrationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataIntegrationOperationBody(builder: GetDataIntegrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FILECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FileConfiguration"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJECTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ObjectConfiguration"))
    val OBJECTCONFIGURATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJECTCONFIGURATION_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val SOURCEURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceURI"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FILECONFIGURATION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OBJECTCONFIGURATION_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(SOURCEURI_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FILECONFIGURATION_DESCRIPTOR.index -> builder.fileConfiguration = deserializeFileConfigurationDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                KMSKEY_DESCRIPTOR.index -> builder.kmsKey = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OBJECTCONFIGURATION_DESCRIPTOR.index -> builder.objectConfiguration =
                    deserializer.deserializeMap(OBJECTCONFIGURATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Map<String, List<String>>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeMap(OBJECTCONFIGURATION_C0_DESCRIPTOR) {
                                        val map1 = mutableMapOf<String, List<String>>()
                                        while (hasNextEntry()) {
                                            val k1 = key()
                                            val v1 =
                                                if (nextHasValue()) {
                                                    deserializer.deserializeList(OBJECTCONFIGURATION_C1_DESCRIPTOR) {
                                                        val col2 = mutableListOf<String>()
                                                        while (hasNextElement()) {
                                                            val el2 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                                            col2.add(el2)
                                                        }
                                                        col2
                                                    }
                                                } else { deserializeNull(); continue }

                                            map1[k1] = v1
                                        }
                                        map1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                SCHEDULECONFIGURATION_DESCRIPTOR.index -> builder.scheduleConfiguration = deserializeScheduleConfigurationDocument(deserializer)
                SOURCEURI_DESCRIPTOR.index -> builder.sourceUri = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
