// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appintegrations.transform

import aws.sdk.kotlin.services.appintegrations.model.AppIntegrationsException
import aws.sdk.kotlin.services.appintegrations.model.EventIntegrationAssociation
import aws.sdk.kotlin.services.appintegrations.model.ListEventIntegrationAssociationsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListEventIntegrationAssociationsOperationDeserializer: HttpDeserialize<ListEventIntegrationAssociationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListEventIntegrationAssociationsResponse {
        if (!response.status.isSuccess()) {
            throwListEventIntegrationAssociationsError(context, response)
        }
        val builder = ListEventIntegrationAssociationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListEventIntegrationAssociationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListEventIntegrationAssociationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppIntegrationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppIntegrationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListEventIntegrationAssociationsOperationBody(builder: ListEventIntegrationAssociationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTINTEGRATIONASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventIntegrationAssociations"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTINTEGRATIONASSOCIATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTINTEGRATIONASSOCIATIONS_DESCRIPTOR.index -> builder.eventIntegrationAssociations =
                    deserializer.deserializeList(EVENTINTEGRATIONASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<EventIntegrationAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventIntegrationAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
