// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties that are applied when using SAPOData as a flow destination
 */
public class SapoDataDestinationProperties private constructor(builder: Builder) {
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * A list of field names that can be used as an ID field when performing a write operation.
     */
    public val idFieldNames: List<String>? = builder.idFieldNames
    /**
     * The object path specified in the SAPOData flow destination.
     */
    public val objectPath: kotlin.String = requireNotNull(builder.objectPath) { "A non-null value must be provided for objectPath" }
    /**
     * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
     *
     * For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
     */
    public val successResponseHandlingConfig: aws.sdk.kotlin.services.appflow.model.SuccessResponseHandlingConfig? = builder.successResponseHandlingConfig
    /**
     * The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
     */
    public val writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = builder.writeOperationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SapoDataDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SapoDataDestinationProperties(")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("idFieldNames=$idFieldNames,")
        append("objectPath=$objectPath,")
        append("successResponseHandlingConfig=$successResponseHandlingConfig,")
        append("writeOperationType=$writeOperationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorHandlingConfig?.hashCode() ?: 0
        result = 31 * result + (idFieldNames?.hashCode() ?: 0)
        result = 31 * result + (objectPath.hashCode())
        result = 31 * result + (successResponseHandlingConfig?.hashCode() ?: 0)
        result = 31 * result + (writeOperationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SapoDataDestinationProperties

        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (idFieldNames != other.idFieldNames) return false
        if (objectPath != other.objectPath) return false
        if (successResponseHandlingConfig != other.successResponseHandlingConfig) return false
        if (writeOperationType != other.writeOperationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SapoDataDestinationProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         */
        public var idFieldNames: List<String>? = null
        /**
         * The object path specified in the SAPOData flow destination.
         */
        public var objectPath: kotlin.String? = null
        /**
         * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
         *
         * For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
         */
        public var successResponseHandlingConfig: aws.sdk.kotlin.services.appflow.model.SuccessResponseHandlingConfig? = null
        /**
         * The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
         */
        public var writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SapoDataDestinationProperties) : this() {
            this.errorHandlingConfig = x.errorHandlingConfig
            this.idFieldNames = x.idFieldNames
            this.objectPath = x.objectPath
            this.successResponseHandlingConfig = x.successResponseHandlingConfig
            this.writeOperationType = x.writeOperationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SapoDataDestinationProperties = SapoDataDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.SuccessResponseHandlingConfig] inside the given [block]
         */
        public fun successResponseHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.SuccessResponseHandlingConfig.Builder.() -> kotlin.Unit) {
            this.successResponseHandlingConfig = aws.sdk.kotlin.services.appflow.model.SuccessResponseHandlingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (objectPath == null) objectPath = ""
            return this
        }
    }
}
