// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties that are applied when the custom connector is being used as a source.
 */
public class CustomConnectorSourceProperties private constructor(builder: Builder) {
    /**
     * Custom properties that are required to use the custom connector as a source.
     */
    public val customProperties: Map<String, String>? = builder.customProperties
    /**
     * The API of the connector application that Amazon AppFlow uses to transfer your data.
     */
    public val dataTransferApi: aws.sdk.kotlin.services.appflow.model.DataTransferApi? = builder.dataTransferApi
    /**
     * The entity specified in the custom connector as a source in the flow.
     */
    public val entityName: kotlin.String = requireNotNull(builder.entityName) { "A non-null value must be provided for entityName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.CustomConnectorSourceProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomConnectorSourceProperties(")
        append("customProperties=$customProperties,")
        append("dataTransferApi=$dataTransferApi,")
        append("entityName=$entityName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customProperties?.hashCode() ?: 0
        result = 31 * result + (dataTransferApi?.hashCode() ?: 0)
        result = 31 * result + (entityName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomConnectorSourceProperties

        if (customProperties != other.customProperties) return false
        if (dataTransferApi != other.dataTransferApi) return false
        if (entityName != other.entityName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.CustomConnectorSourceProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Custom properties that are required to use the custom connector as a source.
         */
        public var customProperties: Map<String, String>? = null
        /**
         * The API of the connector application that Amazon AppFlow uses to transfer your data.
         */
        public var dataTransferApi: aws.sdk.kotlin.services.appflow.model.DataTransferApi? = null
        /**
         * The entity specified in the custom connector as a source in the flow.
         */
        public var entityName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.CustomConnectorSourceProperties) : this() {
            this.customProperties = x.customProperties
            this.dataTransferApi = x.dataTransferApi
            this.entityName = x.entityName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.CustomConnectorSourceProperties = CustomConnectorSourceProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.DataTransferApi] inside the given [block]
         */
        public fun dataTransferApi(block: aws.sdk.kotlin.services.appflow.model.DataTransferApi.Builder.() -> kotlin.Unit) {
            this.dataTransferApi = aws.sdk.kotlin.services.appflow.model.DataTransferApi.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (entityName == null) entityName = ""
            return this
        }
    }
}
